/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.degrade;

import com.github.lianjiatech.retrofit.spring.boot.core.RetrofitClient;
import com.github.lianjiatech.retrofit.spring.boot.degrade.FallbackFactory;
import com.github.lianjiatech.retrofit.spring.boot.degrade.RetrofitBlockException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class DegradeProxy
implements InvocationHandler {
    private final Object source;
    private final Object fallback;
    private final FallbackFactory<?> fallbackFactory;

    public static <T> T create(Object source, Class<T> retrofitInterface, ApplicationContext applicationContext) {
        RetrofitClient retrofitClient = (RetrofitClient)AnnotatedElementUtils.findMergedAnnotation(retrofitInterface, RetrofitClient.class);
        Class<?> fallbackClass = retrofitClient.fallback();
        Object fallback = null;
        if (!Void.TYPE.isAssignableFrom(fallbackClass)) {
            fallback = applicationContext.getBean(fallbackClass);
        }
        Class<?> fallbackFactoryClass = retrofitClient.fallbackFactory();
        FallbackFactory fallbackFactory = null;
        if (!Void.TYPE.isAssignableFrom(fallbackFactoryClass)) {
            fallbackFactory = (FallbackFactory)applicationContext.getBean(fallbackFactoryClass);
        }
        DegradeProxy degradeProxy = new DegradeProxy(source, fallback, fallbackFactory);
        return (T)Proxy.newProxyInstance(retrofitInterface.getClassLoader(), new Class[]{retrofitInterface}, (InvocationHandler)degradeProxy);
    }

    public DegradeProxy(Object source, Object fallback, FallbackFactory<?> fallbackFactory) {
        this.source = source;
        this.fallback = fallback;
        this.fallbackFactory = fallbackFactory;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.source, args);
        }
        catch (Throwable e) {
            Object fallbackObject;
            Throwable cause = e.getCause();
            if (cause instanceof RetrofitBlockException && (fallbackObject = this.getFallbackObject(cause)) != null) {
                return method.invoke(fallbackObject, args);
            }
            throw cause;
        }
    }

    private Object getFallbackObject(Throwable cause) {
        if (this.fallback != null) {
            return this.fallback;
        }
        if (this.fallbackFactory != null) {
            return this.fallbackFactory.create(cause);
        }
        return null;
    }
}

