/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;

public final class BasicTypeConverterFactory
extends Converter.Factory {
    public static final BasicTypeConverterFactory INSTANCE = new BasicTypeConverterFactory();

    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        return null;
    }

    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        if (String.class.getTypeName().equals(type.getTypeName())) {
            return new StringResponseConverter();
        }
        if (Integer.class.getTypeName().equals(type.getTypeName())) {
            return new IntegerResponseConverter();
        }
        if (Long.class.getTypeName().equals(type.getTypeName())) {
            return new LongResponseConverter();
        }
        if (Boolean.class.getTypeName().equals(type.getTypeName())) {
            return new BooleanResponseConverter();
        }
        if (Float.class.getTypeName().equals(type.getTypeName())) {
            return new FloatResponseConverter();
        }
        if (Double.class.getTypeName().equals(type.getTypeName())) {
            return new DoubleResponseConverter();
        }
        return null;
    }

    private BasicTypeConverterFactory() {
    }

    private static final class StringResponseConverter
    implements Converter<ResponseBody, String> {
        private StringResponseConverter() {
        }

        public String convert(ResponseBody value) throws IOException {
            return value.string();
        }
    }

    private static class IntegerResponseConverter
    implements Converter<ResponseBody, Integer> {
        private IntegerResponseConverter() {
        }

        public Integer convert(ResponseBody value) throws IOException {
            return Integer.valueOf(value.string());
        }
    }

    private static class LongResponseConverter
    implements Converter<ResponseBody, Long> {
        private LongResponseConverter() {
        }

        public Long convert(ResponseBody value) throws IOException {
            return Long.valueOf(value.string());
        }
    }

    private static class BooleanResponseConverter
    implements Converter<ResponseBody, Boolean> {
        private BooleanResponseConverter() {
        }

        public Boolean convert(ResponseBody value) throws IOException {
            return Boolean.valueOf(value.string());
        }
    }

    private static class FloatResponseConverter
    implements Converter<ResponseBody, Float> {
        private FloatResponseConverter() {
        }

        public Float convert(ResponseBody value) throws IOException {
            return Float.valueOf(value.string());
        }
    }

    private static class DoubleResponseConverter
    implements Converter<ResponseBody, Double> {
        private DoubleResponseConverter() {
        }

        public Double convert(ResponseBody value) throws IOException {
            return Double.valueOf(value.string());
        }
    }
}

