/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.Cell;
import com.github.liaochong.myexcel.core.ConvertContext;
import com.github.liaochong.myexcel.core.ExcelColumnMapping;
import com.github.liaochong.myexcel.core.ReadContext;
import com.github.liaochong.myexcel.core.Row;
import com.github.liaochong.myexcel.core.RowContext;
import com.github.liaochong.myexcel.core.SaxExcelReader;
import com.github.liaochong.myexcel.core.annotation.ExcelColumn;
import com.github.liaochong.myexcel.core.converter.ReadConverterContext;
import com.github.liaochong.myexcel.core.reflect.ClassFieldContainer;
import com.github.liaochong.myexcel.exception.StopReadException;
import com.github.liaochong.myexcel.utils.ConfigurationUtil;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

abstract class AbstractReadHandler<T> {
    private Map<Integer, Field> fieldMap;
    private T obj;
    protected Map<String, Integer> titles = new HashMap<String, Integer>();
    protected SaxExcelReader.ReadConfig<T> readConfig;
    private BiConsumer<String, Integer> addTitleConsumer = (v, colNum) -> {};
    private ReadContext<T> context = new ReadContext();
    private RowContext rowContext = new RowContext();
    private ConvertContext convertContext;
    private final Row currentRow = new Row(-1);
    private int prevColNum = -1;
    private Supplier<T> newInstance;
    private BiConsumer<Integer, String> fieldHandler;
    private Consumer<T> resultHandler;
    private BiConsumer<T, RowContext> contextResultHandler;
    private boolean readWithTitle;

    public AbstractReadHandler(boolean readCsv, List<T> result, SaxExcelReader.ReadConfig<T> readConfig) {
        boolean isMapType;
        this.convertContext = new ConvertContext(readCsv);
        Class<T> dataType = readConfig.getDataType();
        this.fieldMap = ReflectUtil.getFieldMapOfExcelColumn(dataType);
        this.readConfig = readConfig;
        boolean bl = isMapType = dataType == Map.class;
        if (!isMapType && this.fieldMap.isEmpty()) {
            this.addTitleConsumer = this::addTitles;
            this.readWithTitle = true;
        }
        this.setNewInstanceFunction(dataType, isMapType);
        this.setConfiguration(dataType, isMapType);
        this.setResultHandlerFunction(result, readConfig);
        this.setFieldHandlerFunction(isMapType);
    }

    private void setResultHandlerFunction(List<T> result, SaxExcelReader.ReadConfig<T> readConfig) {
        if (readConfig.getConsumer() != null) {
            this.resultHandler = v -> readConfig.getConsumer().accept(v);
        } else if (readConfig.getFunction() != null) {
            this.resultHandler = v -> {
                Boolean noStop = readConfig.getFunction().apply(v);
                if (!noStop.booleanValue()) {
                    throw new StopReadException();
                }
            };
        } else if (readConfig.getContextConsumer() != null) {
            this.contextResultHandler = (v, context) -> readConfig.getContextConsumer().accept(v, (RowContext)context);
        } else if (readConfig.getContextFunction() != null) {
            this.contextResultHandler = (v, context) -> {
                Boolean noStop = readConfig.getContextFunction().apply(v, (RowContext)context);
                if (!noStop.booleanValue()) {
                    throw new StopReadException();
                }
            };
        } else {
            this.resultHandler = result::add;
        }
    }

    private void setNewInstanceFunction(Class<T> dataType, boolean isMapType) {
        this.newInstance = isMapType ? () -> new LinkedHashMap() : () -> ReflectUtil.newInstance(dataType);
    }

    private void setConfiguration(Class<T> dataType, boolean isMapType) {
        if (isMapType) {
            return;
        }
        ClassFieldContainer classFieldContainer = ReflectUtil.getAllFieldsOfClass(dataType);
        ConfigurationUtil.parseConfiguration(classFieldContainer, this.convertContext.getConfiguration());
        List<Field> fields = classFieldContainer.getFieldsByAnnotation(ExcelColumn.class);
        fields.forEach(field -> {
            ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
            if (excelColumn == null) {
                return;
            }
            ExcelColumnMapping mapping = ExcelColumnMapping.mapping(excelColumn);
            this.convertContext.getExcelColumnMappingMap().put((Field)field, mapping);
        });
    }

    private void setFieldHandlerFunction(boolean isMapType) {
        this.fieldHandler = isMapType ? (colNum, content) -> {
            for (int i = this.prevColNum + 1; i < colNum; ++i) {
                ((Map)this.obj).put(new Cell(this.currentRow.getRowNum(), i), null);
            }
            ((Map)this.obj).put(new Cell(this.currentRow.getRowNum(), (int)colNum), content);
            this.prevColNum = colNum;
        } : (colNum, content) -> {
            Field field = this.fieldMap.get(colNum);
            this.convert((String)content, this.currentRow.getRowNum(), (int)colNum, field);
        };
    }

    protected void convert(String value, int rowNum, int colNum, Field field) {
        if (value == null || field == null) {
            return;
        }
        this.context.reset(this.obj, field, value, rowNum, colNum);
        ReadConverterContext.convert(this.obj, this.context, this.convertContext, this.readConfig.getExceptionFunction());
    }

    private void addTitles(String formattedValue, int thisCol) {
        if (this.currentRow.getRowNum() == 0) {
            this.titles.put(formattedValue, thisCol);
        }
    }

    protected void newRow(int rowNum) {
        this.currentRow.setRowNum(rowNum);
        this.obj = this.newInstance.get();
        this.prevColNum = -1;
    }

    protected void setRecordAsNull() {
        this.obj = null;
    }

    protected void handleField(Integer colNum, String content) {
        if (this.obj == null || colNum < 0) {
            return;
        }
        content = this.readConfig.getTrim().apply(content);
        this.addTitleConsumer.accept(content, colNum);
        if (this.readConfig.getRowFilter().test(this.currentRow)) {
            this.fieldHandler.accept(colNum, content);
        }
    }

    protected void handleResult() {
        this.initFieldMap();
        if (!this.readConfig.getRowFilter().test(this.currentRow)) {
            return;
        }
        if (!this.readConfig.getBeanFilter().test(this.obj)) {
            return;
        }
        if (this.readWithTitle && this.currentRow.getRowNum() == 0) {
            this.readWithTitle = false;
            return;
        }
        if (this.resultHandler != null) {
            this.resultHandler.accept(this.obj);
        } else {
            this.rowContext.setRowNum(this.currentRow.getRowNum());
            this.contextResultHandler.accept(this.obj, this.rowContext);
        }
    }

    private void initFieldMap() {
        if (this.currentRow.getRowNum() != 0 || !this.fieldMap.isEmpty()) {
            return;
        }
        Map<String, Field> titleFieldMap = ReflectUtil.getFieldMapOfTitleExcelColumn(this.readConfig.getDataType());
        this.fieldMap = new HashMap<Integer, Field>(titleFieldMap.size());
        this.titles.forEach((k, v) -> this.fieldMap.put((Integer)v, (Field)titleFieldMap.get(k)));
    }
}

