/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.templatehandler;

import com.github.liaochong.myexcel.core.parser.HtmlTableParser;
import com.github.liaochong.myexcel.core.parser.ParseConfig;
import com.github.liaochong.myexcel.core.parser.Table;
import com.github.liaochong.myexcel.core.templatehandler.TemplateHandler;
import com.github.liaochong.myexcel.exception.ExcelBuildException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public abstract class AbstractTemplateHandler<T, E>
implements TemplateHandler {
    protected static final String CLASSPATH = "classpath";
    protected E templateEngine;

    @Override
    public AbstractTemplateHandler<T, E> classpathTemplate(String path) {
        this.setTemplateEngine(CLASSPATH, () -> this.getTemplateEngineSupplier(CLASSPATH), path);
        return this;
    }

    @Override
    public AbstractTemplateHandler<T, E> fileTemplate(String dirPath, String fileName) {
        this.setTemplateEngine(dirPath, () -> this.getTemplateEngineSupplier(dirPath), fileName);
        return this;
    }

    protected abstract void setTemplateEngine(String var1, Supplier<T> var2, String var3);

    protected abstract T getTemplateEngineSupplier(String var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <F> String render(Map<String, F> renderData) {
        try (StringWriter out = new StringWriter();){
            this.render(renderData, out);
            String string = ((Object)out).toString();
            return string;
        }
        catch (Exception e) {
            throw ExcelBuildException.of("Failed to render template", e);
        }
    }

    protected abstract <F> void render(Map<String, F> var1, Writer var2) throws Exception;

    @Override
    public <F> List<Table> render(Map<String, F> renderData, ParseConfig parseConfig) throws Exception {
        String template = this.render(renderData);
        return HtmlTableParser.of(template).getAllTable(parseConfig);
    }
}

