/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.utils;

import com.github.liaochong.myexcel.core.cache.Cache;
import com.github.liaochong.myexcel.core.cache.WeakCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.nodes.Element;

public final class StyleUtil {
    private static final Cache<String, Map<String, String>> STYLE_CACHE = new WeakCache<String, Map<String, String>>();

    public static Map<String, String> parseStyle(Element element) {
        String style = element.attr("style");
        return StyleUtil.parseStyle(style);
    }

    public static Map<String, String> parseStyle(String style) {
        if (style.length() == 0) {
            return Collections.emptyMap();
        }
        Map<String, String> cacheResult = STYLE_CACHE.get(style);
        if (cacheResult != null) {
            return cacheResult;
        }
        String[] styleArr = style.split(";");
        HashMap<String, String> result = new HashMap<String, String>(styleArr.length);
        int length = styleArr.length;
        for (int i = 0; i < length; ++i) {
            String styleValue;
            String styleName;
            String[] styleDetail = styleArr[i].split(":");
            if (styleDetail.length < 2 || (styleName = styleDetail[0].trim()).length() == 0 || (styleValue = styleDetail[1].trim()).length() == 0) continue;
            result.put(styleName, styleValue);
        }
        STYLE_CACHE.cache(style, result);
        return result;
    }

    public static Map<String, String> mixStyle(Map<String, String> originStyle, Map<String, String> targetStyle) {
        if (targetStyle == null && originStyle == null) {
            return Collections.emptyMap();
        }
        if (targetStyle == null) {
            return new HashMap<String, String>(originStyle);
        }
        if (originStyle == null) {
            return new HashMap<String, String>(targetStyle);
        }
        HashMap<String, String> result = new HashMap<String, String>((targetStyle.size() + originStyle.size()) * 2);
        originStyle.forEach(result::putIfAbsent);
        targetStyle.forEach(result::put);
        return result;
    }
}

