/*
 * Decompiled with CFR 0.152.
 */
package com.github.ydoc.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.ydoc.alert.Alerts;
import com.github.ydoc.config.YDocPropertiesConfig;
import com.github.ydoc.core.AutoTest;
import com.github.ydoc.core.Factory;
import com.github.ydoc.core.TestProject;
import com.github.ydoc.core.YapiAccess;
import com.github.ydoc.exception.YdocException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class YapiApi {
    private static final Logger log = LoggerFactory.getLogger(YapiApi.class);
    private final YDocPropertiesConfig config;
    private final RestTemplate restTemplate;
    private final JavaMailSender javaMailSender;

    public YapiApi(JavaMailSender javaMailSender, YDocPropertiesConfig config, RestTemplate template) {
        this.config = config;
        this.restTemplate = template;
        this.javaMailSender = javaMailSender;
    }

    public void importDoc(boolean cloud, String token, String host, String json) {
        this.checkBefore();
        if (!StringUtils.hasText((String)json)) {
            log.error("json is null, import yapi error");
            return;
        }
        JSONObject param = Factory.get();
        param.put("type", (Object)"swagger");
        param.put("merge", (Object)(cloud ? "good" : "merge"));
        param.put("token", (Object)token);
        param.put("json", (Object)json);
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        HttpEntity formEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(host + "/api/open/import_data", (Object)formEntity, String.class, new Object[0]);
        if (forEntity.getStatusCode() != HttpStatus.OK) {
            log.error("\u5bfc\u5165\u5931\u8d25\uff1a " + JSON.toJSONString((Object)forEntity));
        }
    }

    public YapiAccess login() {
        JSONObject param0 = Factory.get();
        param0.put("email", (Object)this.config.getYapiUserEmail());
        param0.put("password", (Object)this.config.getYapiUserPassword());
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.set("Cookie", "grafana_session=cbb335231019f3ca0dd5e2d69f1361ae");
        HttpEntity formEntity = new HttpEntity((Object)param0, (MultiValueMap)headers);
        ResponseEntity login = this.restTemplate.postForEntity(this.config.getHost() + "/api/user/login", (Object)formEntity, HashMap.class, new Object[0]);
        if (login.getStatusCodeValue() != 200 || login.getBody() == null) {
            throw new YdocException("\u8bf7\u586b\u5199\u6b63\u786e\u7684YApi\u90ae\u7bb1\u548c\u5bc6\u7801\u3002");
        }
        List strings = login.getHeaders().get((Object)"Set-Cookie");
        if (strings.size() > 0 && StringUtils.hasText((String)((String)strings.get(0)))) {
            Map dataObj = (Map)((HashMap)login.getBody()).get("data");
            Integer userId = (Integer)dataObj.get("uid");
            YapiAccess yapiAccess = new YapiAccess();
            yapiAccess.setToken("grafana_session=cbb335231019f3ca0dd5e2d69f1361ae; " + ((String)strings.get(0)).split(";")[0] + "; _yapi_uid=" + userId);
            yapiAccess.setUid(userId);
            return yapiAccess;
        }
        throw new YdocException("\u8ba4\u8bc1\u5931\u8d25\u3002");
    }

    public void checkBefore() {
        if (!StringUtils.hasText((String)this.config.getToken())) {
            throw new YdocException("YApi token can not be null");
        }
        if (!StringUtils.hasText((String)this.config.getHost())) {
            throw new YdocException("YApi host can not be null");
        }
    }

    @Async
    public void autoTest(YapiAccess access) {
        this.checkBefore();
        if (!StringUtils.hasText((String)this.config.getId())) {
            throw new YdocException("object id can not be null");
        }
        if (CollectionUtils.isEmpty(this.config.getTestName())) {
            throw new YdocException("testName can not be empty");
        }
        HttpHeaders getHeaders = new HttpHeaders();
        getHeaders.set("Cookie", access.getToken());
        ResponseEntity entity = this.restTemplate.exchange(this.config.getHost() + "/api/col/list?project_id=" + this.config.getId(), HttpMethod.GET, new HttpEntity((MultiValueMap)getHeaders), TestProject.class, new Object[0]);
        if (entity.getStatusCode() != HttpStatus.OK) {
            log.error("\u83b7\u53d6\u6d4b\u8bd5id\u5931\u8d25\uff1a " + JSON.toJSONString((Object)entity));
            return;
        }
        if (entity.getBody() != null && !CollectionUtils.isEmpty(((TestProject)entity.getBody()).getData())) {
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            for (TestProject.TestId data : ((TestProject)entity.getBody()).getData()) {
                AutoTest body;
                if (!this.config.getTestName().contains(data.getName())) continue;
                param.put("id", data.get_id());
                param.put("token", this.config.getToken());
                ResponseEntity forEntity = this.restTemplate.getForEntity(this.config.getHost() + "api/open/run_auto_test?id={id}&token={token}&mode=json", AutoTest.class, param);
                if (forEntity.getStatusCode() != HttpStatus.OK) {
                    log.error("\u81ea\u52a8\u5316\u6d4b\u8bd5\u6267\u884c\u5931\u8d25\uff1a " + JSON.toJSONString((Object)forEntity));
                }
                if ((body = (AutoTest)forEntity.getBody()) != null) {
                    log.info("YDoc\u81ea\u52a8\u5316\u6d4b\u8bd5[" + data.getName() + "]\u5982\u4e0b:");
                    for (AutoTest.Source source : body.getList()) {
                        log.info("api: [" + source.getName() + "] path: [" + source.getPath() + "]");
                    }
                    if (body.getMessage().getFailedNum() == 0) {
                        log.info(body.getMessage().getMsg() + "\u6d88\u8017\u65f6\u95f4:" + body.getRunTime());
                    } else {
                        log.warn(body.getMessage().getMsg() + "\u6d88\u8017\u65f6\u95f4:" + body.getRunTime());
                    }
                    if (StringUtils.hasText((String)this.config.getAccessToken())) {
                        Alerts.hookDing(this.restTemplate, data.getName(), body.getMessage().getMsg(), this.config.getHost(), this.config.getAccessToken());
                    }
                }
                if (this.javaMailSender == null) continue;
                ResponseEntity html = this.restTemplate.getForEntity(this.config.getHost() + "api/open/run_auto_test?id={id}&token={token}&mode=html", String.class, param);
                if (CollectionUtils.isEmpty(this.config.getToEmails())) continue;
                String utf8 = ((String)html.getBody()).replace("utf8", "utf-8");
                int start = utf8.indexOf("<div class=\"m-header\">");
                int end = utf8.indexOf("<div class=\"g-doc\">");
                Factory.page = utf8 = utf8.subSequence(0, start) + utf8.substring(end);
                Alerts.htmlEmail(this.javaMailSender, utf8, this.config.getYapiUserEmail(), this.config.getToEmails());
            }
        }
    }
}

