/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import com.sun.jna.platform.unix.solaris.LibKstat;
import oshi.hardware.NetworkIF;
import oshi.hardware.common.AbstractNetworks;
import oshi.util.platform.unix.solaris.KstatUtil;

public class SolarisNetworks
extends AbstractNetworks {
    public static void updateNetworkStats(NetworkIF netIF) {
        try (KstatUtil.KstatChain kc = KstatUtil.openChain();){
            LibKstat.Kstat ksp = kc.lookup("link", -1, netIF.getName());
            if (ksp == null) {
                ksp = kc.lookup(null, -1, netIF.getName());
            }
            if (ksp != null && kc.read(ksp)) {
                netIF.setBytesSent(KstatUtil.dataLookupLong(ksp, "obytes64"));
                netIF.setBytesRecv(KstatUtil.dataLookupLong(ksp, "rbytes64"));
                netIF.setPacketsSent(KstatUtil.dataLookupLong(ksp, "opackets64"));
                netIF.setPacketsRecv(KstatUtil.dataLookupLong(ksp, "ipackets64"));
                netIF.setOutErrors(KstatUtil.dataLookupLong(ksp, "oerrors"));
                netIF.setInErrors(KstatUtil.dataLookupLong(ksp, "ierrors"));
                netIF.setSpeed(KstatUtil.dataLookupLong(ksp, "ifspeed"));
                netIF.setTimeStamp(ksp.ks_snaptime / 1000000L);
            }
        }
    }
}

