/*
 * Decompiled with CFR 0.152.
 */
package com.github.qcloudsms;

import com.github.qcloudsms.SmsSenderUtil;
import com.github.qcloudsms.SmsSingleSenderResult;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmsSingleSender {
    int appid;
    String appkey;
    String url = "https://yun.tim.qq.com/v5/tlssmssvr/sendsms";
    SmsSenderUtil util = new SmsSenderUtil();

    public SmsSingleSender(int appid, String appkey) throws Exception {
        this.appid = appid;
        this.appkey = appkey;
    }

    public SmsSingleSenderResult send(int type, String nationCode, String phoneNumber, String msg, String extend, String ext) throws Exception {
        SmsSingleSenderResult result;
        if (0 != type && 1 != type) {
            throw new Exception("type " + type + " error");
        }
        if (null == extend) {
            extend = "";
        }
        if (null == ext) {
            ext = "";
        }
        long random = this.util.getRandom();
        long curTime = System.currentTimeMillis() / 1000L;
        JSONObject data = new JSONObject();
        JSONObject tel = new JSONObject();
        tel.put("nationcode", (Object)nationCode);
        tel.put("mobile", (Object)phoneNumber);
        data.put("type", type);
        data.put("msg", (Object)msg);
        data.put("sig", (Object)this.util.strToHash(String.format("appkey=%s&random=%d&time=%d&mobile=%s", this.appkey, random, curTime, phoneNumber)));
        data.put("tel", (Object)tel);
        data.put("time", curTime);
        data.put("extend", (Object)extend);
        data.put("ext", (Object)ext);
        String wholeUrl = String.format("%s?sdkappid=%d&random=%d", this.url, this.appid, random);
        HttpURLConnection conn = this.util.getPostHttpConn(wholeUrl);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream(), "utf-8");
        wr.write(data.toString());
        wr.flush();
        StringBuilder sb = new StringBuilder();
        int httpRspCode = conn.getResponseCode();
        if (httpRspCode == 200) {
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            JSONObject json = new JSONObject(sb.toString());
            result = this.util.jsonToSmsSingleSenderResult(json);
        } else {
            result = new SmsSingleSenderResult();
            result.result = httpRspCode;
            result.errMsg = "http error " + httpRspCode + " " + conn.getResponseMessage();
        }
        return result;
    }

    public SmsSingleSenderResult sendWithParam(String nationCode, String phoneNumber, int templId, ArrayList<String> params, String sign, String extend, String ext) throws Exception {
        SmsSingleSenderResult result;
        if (null == nationCode || 0 == nationCode.length()) {
            nationCode = "86";
        }
        if (null == params) {
            params = new ArrayList();
        }
        if (null == sign) {
            sign = "";
        }
        if (null == extend) {
            extend = "";
        }
        if (null == ext) {
            ext = "";
        }
        long random = this.util.getRandom();
        long curTime = System.currentTimeMillis() / 1000L;
        JSONObject data = new JSONObject();
        JSONObject tel = new JSONObject();
        tel.put("nationcode", (Object)nationCode);
        tel.put("mobile", (Object)phoneNumber);
        data.put("tel", (Object)tel);
        data.put("sig", (Object)this.util.calculateSigForTempl(this.appkey, random, curTime, phoneNumber));
        data.put("tpl_id", templId);
        data.put("params", (Object)this.util.smsParamsToJSONArray(params));
        data.put("sign", (Object)sign);
        data.put("time", curTime);
        data.put("extend", (Object)extend);
        data.put("ext", (Object)ext);
        String wholeUrl = String.format("%s?sdkappid=%d&random=%d", this.url, this.appid, random);
        HttpURLConnection conn = this.util.getPostHttpConn(wholeUrl);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream(), "utf-8");
        wr.write(data.toString());
        wr.flush();
        StringBuilder sb = new StringBuilder();
        int httpRspCode = conn.getResponseCode();
        if (httpRspCode == 200) {
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            JSONObject json = new JSONObject(sb.toString());
            result = this.util.jsonToSmsSingleSenderResult(json);
        } else {
            result = new SmsSingleSenderResult();
            result.result = httpRspCode;
            result.errMsg = "http error " + httpRspCode + " " + conn.getResponseMessage();
        }
        return result;
    }
}

