/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.service;

import com.github.scribejava.apis.ImgurApi;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.oauth.OAuth20Service;

public class ImgurOAuthServiceImpl
extends OAuth20Service {
    public ImgurOAuthServiceImpl(DefaultApi20 api, OAuthConfig config) {
        super(api, config);
    }

    protected <T extends AbstractRequest> T createAccessTokenRequest(String oauthVerifier, T request) {
        OAuthConfig config = this.getConfig();
        request.addBodyParameter("client_id", config.getApiKey());
        request.addBodyParameter("client_secret", config.getApiSecret());
        if (ImgurApi.isOob(config)) {
            request.addBodyParameter("grant_type", "pin");
            request.addBodyParameter("pin", oauthVerifier);
        } else {
            request.addBodyParameter("grant_type", "authorization_code");
            request.addBodyParameter("code", oauthVerifier);
        }
        return request;
    }

    public void signRequest(OAuth2AccessToken accessToken, AbstractRequest request) {
        request.addHeader("Authorization", accessToken == null ? "Client-ID " + this.getConfig().getApiKey() : "Bearer " + accessToken.getAccessToken());
    }
}

