/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class IpUtil {
    private static String serverIp;

    public static String getServerIp() {
        return serverIp;
    }

    public static Map<String, String> getLocalIPV4() {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress ip = ips.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    map.put(ni.getName(), ip.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, String> getLocalIPV6() {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress ip = ips.nextElement();
                    if (!(ip instanceof Inet6Address)) continue;
                    map.put(ni.getName(), ip.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    static {
        try {
            InetAddress ia = InetAddress.getLocalHost();
            serverIp = ia.getHostAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

