/*
 * Decompiled with CFR 0.152.
 */
package com.smartdoc.mojo;

import com.power.common.util.CollectionUtil;
import com.power.common.util.DateTimeUtil;
import com.power.common.util.RegexUtil;
import com.power.common.util.StringUtil;
import com.power.doc.model.ApiConfig;
import com.smartdoc.util.ArtifactFilterUtil;
import com.smartdoc.util.ClassLoaderUtil;
import com.smartdoc.util.FileUtil;
import com.smartdoc.util.MojoUtils;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;

public abstract class BaseDocsGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Parameter(property="scope")
    private String scope;
    @Parameter(property="configFile", defaultValue="./src/main/resources/default.json")
    private File configFile;
    @Parameter(property="projectName")
    private String projectName;
    @Parameter(required=false)
    private Set excludes;
    @Parameter(required=false)
    private Set includes;
    @Parameter(property="skip")
    private String skip;
    private DependencyNode rootNode;
    protected JavaProjectBuilder javaProjectBuilder;
    private List<String> projectArtifacts;

    public abstract void executeMojo(ApiConfig var1, JavaProjectBuilder var2) throws MojoExecutionException, MojoFailureException;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String outPath;
        if ("true".equals(this.skip)) {
            return;
        }
        if (Objects.nonNull(this.configFile) && !this.configFile.exists()) {
            this.getLog().warn((CharSequence)("Can't find config file: " + this.configFile.getName() + " from [" + this.project.getName() + "],If it is a non-web module, please ignore the error."));
            return;
        }
        this.getLog().info((CharSequence)("Smart-doc Start preparing sources at: " + DateTimeUtil.nowStrTime()));
        this.projectArtifacts = new ArrayList<String>();
        this.javaProjectBuilder = this.buildJavaProjectBuilder();
        this.javaProjectBuilder.setEncoding("utf-8");
        ApiConfig apiConfig = MojoUtils.buildConfig(this.configFile, this.projectName, this.project, this.projectArtifacts, this.getLog());
        if (Objects.isNull(apiConfig)) {
            this.getLog().info((CharSequence)"Failed to build ApiConfig, check if the configuration file is correct.");
            return;
        }
        String rpcConsumerConfig = apiConfig.getRpcConsumerConfig();
        if (!FileUtil.isAbsPath(rpcConsumerConfig) && StringUtil.isNotEmpty((String)rpcConsumerConfig)) {
            apiConfig.setRpcConsumerConfig(this.project.getBasedir().getPath() + "/" + rpcConsumerConfig);
        }
        if (!FileUtil.isAbsPath(outPath = apiConfig.getOutPath()) && StringUtil.isNotEmpty((String)outPath)) {
            apiConfig.setOutPath(this.project.getBasedir().getPath() + "/" + outPath);
        }
        this.getLog().info((CharSequence)("Smart-doc Starting Create API Documentation at: " + DateTimeUtil.nowStrTime()));
        this.getLog().info((CharSequence)("API documentation is output to " + outPath));
        this.executeMojo(apiConfig, this.javaProjectBuilder);
    }

    private JavaProjectBuilder buildJavaProjectBuilder() throws MojoExecutionException {
        JavaProjectBuilder javaDocBuilder = new JavaProjectBuilder();
        javaDocBuilder.setEncoding("utf-8");
        javaDocBuilder.setErrorHandler(e -> this.getLog().warn((CharSequence)e.getMessage()));
        javaDocBuilder.addSourceTree(new File("src/main/java"));
        javaDocBuilder.addClassLoader(ClassLoaderUtil.getRuntimeClassLoader(this.project));
        this.loadSourcesDependencies(javaDocBuilder);
        return javaDocBuilder;
    }

    private void loadSourcesDependencies(JavaProjectBuilder javaDocBuilder) throws MojoExecutionException {
        try {
            List<String> currentProjectModules = this.getCurrentProjectArtifacts(this.project);
            ArtifactFilter artifactFilter = this.createResolvingArtifactFilter();
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setProject(this.project);
            this.rootNode = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, artifactFilter, this.reactorProjects);
            List dependencyNodes = this.rootNode.getChildren();
            List<Artifact> artifactList = this.getArtifacts(dependencyNodes);
            artifactList.forEach(artifact -> {
                if (ArtifactFilterUtil.ignoreSpringBootArtifactById(artifact)) {
                    return;
                }
                String artifactName = artifact.getGroupId() + ":" + artifact.getArtifactId();
                if (currentProjectModules.contains(artifactName)) {
                    this.projectArtifacts.add(artifactName);
                    return;
                }
                if (RegexUtil.isMatches((Set)this.excludes, (String)artifactName)) {
                    return;
                }
                if (RegexUtil.isMatches((Set)this.includes, (String)artifactName)) {
                    this.getLog().debug((CharSequence)("load includes artifact: " + artifactName));
                    Artifact sourcesArtifact = this.repositorySystem.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), "sources");
                    this.projectArtifacts.add(artifactName);
                    this.loadSourcesDependency(javaDocBuilder, sourcesArtifact);
                    return;
                }
                if (this.includes == null) {
                    Artifact sourcesArtifact = this.repositorySystem.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), "sources");
                    this.projectArtifacts.add(artifactName);
                    this.loadSourcesDependency(javaDocBuilder, sourcesArtifact);
                }
            });
        }
        catch (DependencyGraphBuilderException e) {
            throw new MojoExecutionException("Can't build project dependency graph", (Exception)((Object)e));
        }
    }

    private void loadSourcesDependency(JavaProjectBuilder javaDocBuilder, Artifact sourcesArtifact) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(sourcesArtifact);
        request.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        result.getArtifacts().forEach(artifact -> {
            try (JarFile jarFile = new JarFile(artifact.getFile());){
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("smart-doc loaded jar source:" + artifact.getFile().toURI().toURL().toString()));
                }
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.endsWith(".java") || name.endsWith("/package-info.java")) continue;
                    javaDocBuilder.addSource(new URL("jar:" + artifact.getFile().toURI().toURL().toString() + "!/" + name));
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Unable to load jar source " + artifact + " : " + e.getMessage()));
            }
        });
    }

    private ArtifactFilter createResolvingArtifactFilter() {
        ScopeArtifactFilter filter;
        if (this.scope != null) {
            this.getLog().debug((CharSequence)("+ Resolving dependency tree for scope '" + this.scope + "'"));
            filter = new ScopeArtifactFilter(this.scope);
        } else {
            filter = null;
        }
        return filter;
    }

    private List<Artifact> getArtifacts(List<DependencyNode> dependencyNodes) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        if (CollectionUtil.isEmpty(dependencyNodes)) {
            return artifacts;
        }
        for (DependencyNode dependencyNode : dependencyNodes) {
            if (ArtifactFilterUtil.ignoreArtifact(dependencyNode.getArtifact())) continue;
            artifacts.add(dependencyNode.getArtifact());
            if (dependencyNode.getChildren().size() <= 0) continue;
            artifacts.addAll(this.getArtifacts(dependencyNode.getChildren()));
        }
        return artifacts;
    }

    private List<String> getCurrentProjectArtifacts(MavenProject project) {
        File file;
        if (!project.hasParent()) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> finalArtifactsName = new ArrayList<String>();
        MavenProject mavenProject = project.getParent();
        if (Objects.nonNull(mavenProject) && !Objects.isNull(file = mavenProject.getBasedir())) {
            String groupId = mavenProject.getGroupId();
            List moduleList = mavenProject.getModules();
            moduleList.forEach(str -> finalArtifactsName.add(groupId + ":" + str));
        }
        return finalArtifactsName;
    }
}

