/*
 * Decompiled with CFR 0.152.
 */
package com.smartdoc.util;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.power.common.util.FileUtil;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.SourceCodePath;
import com.smartdoc.constant.GlobalConstants;
import com.smartdoc.util.ClassLoaderUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class MojoUtils {
    public static final Gson GSON = new GsonBuilder().addDeserializationExclusionStrategy(new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return false;
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }).create();

    public static ApiConfig buildConfig(File configFile, String projectName, MavenProject project, List<String> projectArtifacts, Log log) throws MojoExecutionException {
        try {
            ClassLoader classLoader = ClassLoaderUtil.getRuntimeClassLoader(project);
            String data = FileUtil.getFileContent((InputStream)new FileInputStream(configFile));
            ApiConfig apiConfig = (ApiConfig)GSON.fromJson(data, ApiConfig.class);
            List apiDataDictionaries = apiConfig.getDataDictionaries();
            List apiErrorCodes = apiConfig.getErrorCodeDictionaries();
            List apiConstants = apiConfig.getApiConstants();
            if (apiErrorCodes != null) {
                apiErrorCodes.forEach(apiErrorCode -> {
                    String className = apiErrorCode.getEnumClassName();
                    apiErrorCode.setEnumClass(MojoUtils.getClassByClassName(className, classLoader));
                });
            }
            if (apiDataDictionaries != null) {
                apiDataDictionaries.forEach(apiDataDictionary -> {
                    String className = apiDataDictionary.getEnumClassName();
                    apiDataDictionary.setEnumClass(MojoUtils.getClassByClassName(className, classLoader));
                });
            }
            if (apiConstants != null) {
                apiConstants.forEach(apiConstant -> {
                    String className = apiConstant.getConstantsClassName();
                    apiConstant.setConstantsClass(MojoUtils.getClassByClassName(className, classLoader));
                });
            }
            if (StringUtils.isBlank((CharSequence)apiConfig.getProjectName())) {
                apiConfig.setProjectName(projectName);
            }
            MojoUtils.addSourcePaths(project, apiConfig, projectArtifacts, log);
            return apiConfig;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class getClassByClassName(String className, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void addSourcePaths(MavenProject project, ApiConfig apiConfig, List<String> projectArtifacts, Log log) {
        ArrayList<SourceCodePath> sourceCodePaths = new ArrayList<SourceCodePath>();
        HashMap<String, String> modules = new HashMap<String, String>();
        MojoUtils.getRootPath(project, modules);
        modules.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            String modulePath = (String)entry.getValue();
            projectArtifacts.forEach(artifactName -> {
                if (artifactName.equals(key)) {
                    sourceCodePaths.add(SourceCodePath.builder().setPath(modulePath));
                }
            });
        });
        sourceCodePaths.add(SourceCodePath.builder().setPath(project.getBasedir() + GlobalConstants.FILE_SEPARATOR + "/src/main/java"));
        SourceCodePath[] codePaths = new SourceCodePath[sourceCodePaths.size()];
        sourceCodePaths.toArray(codePaths);
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Artifacts that the current project depends on: " + projectArtifacts));
            log.debug((CharSequence)("Smart-doc has loaded the source code path: " + sourceCodePaths));
        }
        apiConfig.setSourceCodePaths(codePaths);
    }

    private static void getSourceCodeFilePath(File file, List<String> path) {
        File[] fs = file.listFiles();
        assert (fs != null);
        for (File f : fs) {
            if (!f.isDirectory()) continue;
            if (f.getPath().endsWith("/src/main/java") || f.getPath().endsWith("\\src\\main\\java")) {
                path.add(f.getPath());
            }
            MojoUtils.getSourceCodeFilePath(f, path);
        }
    }

    private static File getRootPath(MavenProject project, Map<String, String> moduleList) {
        if (project.hasParent()) {
            MavenProject mavenProject = project.getParent();
            if (null != mavenProject) {
                if (mavenProject.getBasedir() == null) {
                    return project.getBasedir();
                }
                List modules = mavenProject.getModules();
                String groupId = mavenProject.getGroupId();
                for (String module : modules) {
                    moduleList.put(groupId + ":" + module, mavenProject.getBasedir() + GlobalConstants.FILE_SEPARATOR + module + GlobalConstants.FILE_SEPARATOR + "/src/main/java");
                }
                return MojoUtils.getRootPath(mavenProject, moduleList);
            }
            return project.getBasedir();
        }
        return project.getBasedir();
    }
}

