/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.power.common.util.CollectionUtil;
import com.power.common.util.FileUtil;
import com.power.common.util.StringUtil;
import com.power.doc.builder.DocBuilderTemplate;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.Methods;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqHeader;
import com.power.doc.template.SpringBootDocBuildTemplate;
import com.power.doc.utils.DocUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpenApiBuilder {
    private static final String PATH_REGEX = "[/{};\\t+]";

    public static void buildOpenApi(ApiConfig config) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        OpenApiBuilder.openApiCreate(config, configBuilder);
    }

    public static void buildOpenApi(ApiConfig config, JavaProjectBuilder projectBuilder) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, projectBuilder);
        OpenApiBuilder.openApiCreate(config, configBuilder);
    }

    private static void openApiCreate(ApiConfig config, ProjectDocConfigBuilder configBuilder) {
        config.setParamsDataToTree(true);
        SpringBootDocBuildTemplate docBuildTemplate = new SpringBootDocBuildTemplate();
        List<ApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder);
        HashMap<String, Object> json = new HashMap<String, Object>(8);
        json.put("openapi", "3.0.0");
        json.put("info", OpenApiBuilder.buildInfo(config));
        json.put("servers", OpenApiBuilder.buildServers(config));
        json.put("paths", OpenApiBuilder.buildPaths(apiDocList));
        json.put("components", OpenApiBuilder.buildComponentsSchema(apiDocList));
        String filePath = config.getOutPath();
        filePath = filePath + "/openApi3.0.json";
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String data = gson.toJson(json);
        FileUtil.nioWriteFile((String)data, (String)filePath);
    }

    private static Map<String, Object> buildInfo(ApiConfig apiConfig) {
        HashMap<String, Object> infoMap = new HashMap<String, Object>(8);
        infoMap.put("title", apiConfig.getProjectName() == null ? "\u672a\u8bbe\u7f6e\u9879\u76ee\u540d\u79f0" : apiConfig.getProjectName());
        infoMap.put("version", "1.0.0");
        return infoMap;
    }

    private static List<Map<String, Object>> buildServers(ApiConfig config) {
        ArrayList<Map<String, Object>> serverList = new ArrayList<Map<String, Object>>();
        HashMap<String, String> serverMap = new HashMap<String, String>(8);
        serverMap.put("url", config.getServerUrl() == null ? "http://127.0.0.1" : config.getServerUrl());
        serverList.add(serverMap);
        return serverList;
    }

    private static Map<String, Object> buildPaths(List<ApiDoc> apiDocList) {
        HashMap<String, Object> pathMap = new HashMap<String, Object>(500);
        apiDocList.forEach(a -> {
            List<ApiMethodDoc> apiMethodDocs = a.getList();
            apiMethodDocs.forEach(method -> {
                String url = method.getPath().replace("//", "/");
                Map<String, Object> request = OpenApiBuilder.buildPathUrls(method, a);
                if (!pathMap.containsKey(url)) {
                    pathMap.put(url, request);
                } else {
                    Map oldRequest = (Map)pathMap.get(url);
                    oldRequest.putAll(request);
                }
            });
        });
        return pathMap;
    }

    private static Map<String, Object> buildPathUrls(ApiMethodDoc apiMethodDoc, ApiDoc apiDoc) {
        HashMap<String, Object> request = new HashMap<String, Object>(4);
        request.put(apiMethodDoc.getType().toLowerCase(), OpenApiBuilder.buildPathUrlsRequest(apiMethodDoc, apiDoc));
        return request;
    }

    private static Map<String, Object> buildPathUrlsRequest(ApiMethodDoc apiMethodDoc, ApiDoc apiDoc) {
        HashMap<String, Object> request = new HashMap<String, Object>(20);
        request.put("summary", apiMethodDoc.getDesc());
        request.put("description", apiMethodDoc.getDetail());
        request.put("tags", new String[]{apiDoc.getDesc()});
        request.put("requestBody", OpenApiBuilder.buildRequestBody(apiMethodDoc));
        request.put("parameters", OpenApiBuilder.buildParameters(apiMethodDoc));
        request.put("responses", OpenApiBuilder.buildResponses(apiMethodDoc));
        return request;
    }

    private static Map<String, Object> buildRequestBody(ApiMethodDoc apiMethodDoc) {
        boolean isPost;
        int size = 0;
        HashMap<String, Object> requestBody = new HashMap<String, Object>(8);
        if (!CollectionUtil.isEmpty(apiMethodDoc.getRequestParams())) {
            List<ApiParam> apiParams = apiMethodDoc.getRequestParams();
            size = (int)apiParams.stream().filter(apiParam -> !apiParam.isPathParam()).count();
        }
        boolean bl = isPost = (apiMethodDoc.getType().equals(Methods.POST.getValue()) || apiMethodDoc.getType().equals(Methods.PUT.getValue()) || apiMethodDoc.getType().equals(Methods.PATCH.getValue())) && size > 0;
        if (isPost) {
            requestBody.put("content", OpenApiBuilder.buildContent(apiMethodDoc, false));
            return requestBody;
        }
        return null;
    }

    private static Map<String, Object> buildContent(ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        content.put(apiMethodDoc.getContentType(), OpenApiBuilder.buildContentBody(apiMethodDoc, isRep));
        return content;
    }

    private static Map<String, Object> buildContentBody(ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        content.put("schema", OpenApiBuilder.buildBodySchema(apiMethodDoc.getPath(), isRep));
        content.put("examples", OpenApiBuilder.buildBodyExample(apiMethodDoc, isRep));
        return content;
    }

    private static Map<String, Object> buildBodySchema(String url, boolean isRep) {
        HashMap<String, Object> schema = new HashMap<String, Object>(10);
        if (isRep) {
            schema.put("$ref", "#/components/schemas/" + url.replaceAll(PATH_REGEX, "_") + "response");
        } else {
            schema.put("$ref", "#/components/schemas/" + url.replaceAll(PATH_REGEX, "_") + "request");
        }
        return schema;
    }

    private static Map<String, Object> buildBodyExample(ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        content.put("json", OpenApiBuilder.buildExampleData(apiMethodDoc, isRep));
        return content;
    }

    private static Map<String, Object> buildExampleData(ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        content.put("summary", "test data");
        if (!isRep) {
            content.put("value", StringUtil.isEmpty((String)apiMethodDoc.getRequestExample().getJsonBody()) ? apiMethodDoc.getRequestExample().getExampleBody() : apiMethodDoc.getRequestExample().getJsonBody());
        } else {
            content.put("value", apiMethodDoc.getResponseUsage());
        }
        return content;
    }

    private static List<Map<String, Object>> buildParameters(ApiMethodDoc apiMethodDoc) {
        HashMap<String, Object> parameters;
        ArrayList<Map<String, Object>> parametersList = new ArrayList<Map<String, Object>>();
        if (apiMethodDoc.getType().equals(Methods.GET.getValue()) || apiMethodDoc.getPath().contains("{")) {
            if (apiMethodDoc.getRequestParams() == null) {
                return null;
            }
            for (ApiParam apiParam : apiMethodDoc.getRequestParams()) {
                parameters = new HashMap<String, Object>(20);
                parameters.put("name", apiParam.getField());
                parameters.put("description", apiParam.getDesc());
                parameters.put("required", apiParam.isRequired());
                parameters.put("schema", OpenApiBuilder.buildParametersSchema(apiParam));
                if (apiParam.isPathParam()) {
                    parameters.put("in", "path");
                } else {
                    parameters.put("in", "query");
                }
                parametersList.add(parameters);
            }
        }
        if (!CollectionUtil.isEmpty(apiMethodDoc.getRequestHeaders())) {
            for (ApiReqHeader header : apiMethodDoc.getRequestHeaders()) {
                parameters = new HashMap(20);
                parameters.put("name", header.getName());
                parameters.put("description", header.getDesc());
                parameters.put("required", header.isRequired());
                parameters.put("schema", OpenApiBuilder.buildParametersSchema(header));
                parameters.put("in", "header");
                parametersList.add(parameters);
            }
        }
        return parametersList;
    }

    private static Map<String, Object> buildParametersSchema(ApiParam apiParam) {
        HashMap<String, Object> schema = new HashMap<String, Object>(10);
        String openApiType = DocUtil.javaTypeToOpenApiTypeConvert(apiParam.getType());
        schema.put("type", openApiType);
        if ("object".equals(openApiType) || "string".equals(openApiType)) {
            if ("file".equals(apiParam.getType())) {
                schema.put("format", "binary");
            }
        } else {
            schema.put("format", "int16".equals(apiParam.getType()) ? "int32" : apiParam.getType());
        }
        return schema;
    }

    private static Map<String, Object> buildParametersSchema(ApiReqHeader header) {
        HashMap<String, Object> schema = new HashMap<String, Object>(10);
        String openApiType = DocUtil.javaTypeToOpenApiTypeConvert(header.getType());
        schema.put("type", openApiType);
        schema.put("format", "int16".equals(header.getType()) ? "int32" : header.getType());
        return schema;
    }

    private static Map<String, Object> buildResponses(ApiMethodDoc apiMethodDoc) {
        HashMap<String, Object> response = new HashMap<String, Object>(10);
        response.put("200", OpenApiBuilder.buildResponsesBody(apiMethodDoc));
        return response;
    }

    private static Map<String, Object> buildResponsesBody(ApiMethodDoc apiMethodDoc) {
        HashMap<String, Object> responseBody = new HashMap<String, Object>(10);
        responseBody.put("description", "a pet to be returned");
        if (!CollectionUtil.isEmpty(apiMethodDoc.getResponseParams())) {
            responseBody.put("content", OpenApiBuilder.buildContent(apiMethodDoc, true));
        }
        return responseBody;
    }

    private static Map<String, Object> buildComponentsSchema(List<ApiDoc> apiDocs) {
        HashMap<String, Object> schemas = new HashMap<String, Object>(4);
        HashMap component = new HashMap();
        apiDocs.forEach(a -> {
            List<ApiMethodDoc> apiMethodDocs = a.getList();
            apiMethodDocs.forEach(method -> {
                List<ApiParam> requestParams = method.getRequestParams();
                component.put(method.getPath().replaceAll(PATH_REGEX, "_") + "request", OpenApiBuilder.buildProperties(requestParams));
                List<ApiParam> responseParams = method.getResponseParams();
                component.put(method.getPath().replaceAll(PATH_REGEX, "_") + "response", OpenApiBuilder.buildProperties(responseParams));
            });
        });
        schemas.put("schemas", component);
        return schemas;
    }

    private static Map<String, Object> buildProperties(List<ApiParam> apiParam) {
        HashMap<String, Object> component = new HashMap<String, Object>();
        HashMap<String, Map<String, Object>> propertiesData = new HashMap<String, Map<String, Object>>();
        ArrayList<String> requiredList = new ArrayList<String>();
        if (apiParam != null) {
            for (ApiParam param : apiParam) {
                if (param.isRequired()) {
                    requiredList.add(param.getField());
                }
                String field = param.getField();
                propertiesData.put(field, OpenApiBuilder.buildPropertiesData(param));
            }
            component.put("properties", propertiesData);
            if (!CollectionUtil.isEmpty(requiredList)) {
                component.put("required", requiredList);
            }
            return component;
        }
        return null;
    }

    private static Map<String, Object> buildPropertiesData(ApiParam apiParam) {
        HashMap<String, Object> propertiesData = new HashMap<String, Object>();
        String openApiType = DocUtil.javaTypeToOpenApiTypeConvert(apiParam.getType());
        propertiesData.put("description", apiParam.getDesc());
        if (!"object".equals(openApiType)) {
            propertiesData.put("type", openApiType);
            propertiesData.put("format", "int16".equals(apiParam.getType()) ? "int32" : apiParam.getType());
        }
        if ("map".equals(apiParam.getType())) {
            propertiesData.put("type", "object");
            propertiesData.put("description", apiParam.getDesc() + "(map data)");
        }
        if ("object".equals(apiParam.getType()) && apiParam.getChildren() != null) {
            propertiesData.put("type", "object");
            propertiesData.put("description", apiParam.getDesc() + "(object)");
            propertiesData.put("properties", OpenApiBuilder.buildProperties(apiParam.getChildren()).get("properties"));
            propertiesData.put("requires", OpenApiBuilder.buildProperties(apiParam.getChildren()).get("requires"));
        }
        if ("array".equals(apiParam.getType()) && apiParam.getChildren() != null) {
            propertiesData.put("type", "array");
            propertiesData.put("items", OpenApiBuilder.buildProperties(apiParam.getChildren()));
        }
        if ("file".equals(apiParam.getType())) {
            propertiesData.put("type", "string");
            propertiesData.put("format", "binary");
        }
        return propertiesData;
    }
}

