/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.power.common.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;

public class BeetlTemplateUtil {
    public static Template getByName(String templateName) {
        try {
            ClasspathResourceLoader resourceLoader = new ClasspathResourceLoader("/template/");
            Configuration cfg = Configuration.defaultConfiguration();
            cfg.add("/smart-doc-beetl.properties");
            GroupTemplate gt = new GroupTemplate((ResourceLoader)resourceLoader, cfg);
            return gt.getTemplate((Object)templateName);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't get Beetl template.");
        }
    }

    public static Map<String, String> getTemplatesRendered(String path, Map<String, Object> params) {
        HashMap<String, String> templateMap = new HashMap<String, String>();
        File[] files = FileUtil.getResourceFolderFiles((String)path);
        GroupTemplate gt = BeetlTemplateUtil.getGroupTemplate(path);
        for (File f : files) {
            if (!f.isFile()) continue;
            String fileName = f.getName();
            Template tp = gt.getTemplate((Object)fileName);
            if (null != params) {
                tp.binding(params);
            }
            templateMap.put(fileName, tp.render());
        }
        return templateMap;
    }

    private static GroupTemplate getGroupTemplate(String path) {
        try {
            ClasspathResourceLoader resourceLoader = new ClasspathResourceLoader("/" + path + "/");
            Configuration cfg = Configuration.defaultConfiguration();
            GroupTemplate gt = new GroupTemplate((ResourceLoader)resourceLoader, cfg);
            return gt;
        }
        catch (IOException e) {
            throw new RuntimeException("Can't get Beetl template.");
        }
    }
}

