/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.FileUtil;
import com.power.doc.builder.DocBuilderTemplate;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.DocGlobalConstants;
import com.power.doc.factory.BuildTemplateFactory;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.template.IDocBuildTemplate;
import com.power.doc.utils.BeetlTemplateUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.beetl.core.Template;

public class HtmlApiDocBuilder {
    private static final String ERROR_CODE_HTML = "error.html";
    private static final String DICT_HTML = "dict.html";
    private static long now = System.currentTimeMillis();
    private static String INDEX_HTML = "index.html";

    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        HtmlApiDocBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        config.setParamsDataToTree(false);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        IDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getDocBuildTemplate(config.getFramework());
        List<ApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder);
        Template indexCssTemplate = BeetlTemplateUtil.getByName("css/AllInOne.css");
        FileUtil.nioWriteFile((String)indexCssTemplate.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "AllInOne.css"));
        DocBuilderTemplate.copyJarFile("js/highlight.min.js", config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "highlight.min.js");
        DocBuilderTemplate.copyJarFile("css/font.css", config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "font.css");
        DocBuilderTemplate.copyJarFile("js/jquery.min.js", config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "jquery.min.js");
        DocBuilderTemplate.copyJarFile("css/xt256.min.css", config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "xt256.min.css");
        if (config.isAllInOne()) {
            apiDocList = docBuildTemplate.handleApiGroup(apiDocList, config);
            if (config.isCreateDebugPage()) {
                INDEX_HTML = "debug-all.html";
                if (StringUtils.isNotEmpty((CharSequence)config.getAllInOneDocFileName())) {
                    INDEX_HTML = config.getAllInOneDocFileName();
                }
                builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "debug-all.html", INDEX_HTML);
                Template mockJs = BeetlTemplateUtil.getByName("js/debug.js");
                FileUtil.nioWriteFile((String)mockJs.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "debug.js"));
            } else {
                if (StringUtils.isNotEmpty((CharSequence)config.getAllInOneDocFileName())) {
                    INDEX_HTML = config.getAllInOneDocFileName();
                }
                builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "AllInOne.html", INDEX_HTML);
            }
            builderTemplate.buildSearchJs(config, javaProjectBuilder, apiDocList, "js/search_all.js.btl");
        } else {
            String indexAlias;
            if (config.isCreateDebugPage()) {
                indexAlias = "debug";
                HtmlApiDocBuilder.buildDoc(builderTemplate, apiDocList, config, javaProjectBuilder, "html/debug.html", indexAlias);
                Template mockJs = BeetlTemplateUtil.getByName("js/debug.js");
                FileUtil.nioWriteFile((String)mockJs.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "debug.js"));
            } else {
                indexAlias = "api";
                HtmlApiDocBuilder.buildDoc(builderTemplate, apiDocList, config, javaProjectBuilder, "html/index.html", indexAlias);
            }
            builderTemplate.buildErrorCodeDoc(config, javaProjectBuilder, apiDocList, "html/error.html", ERROR_CODE_HTML, indexAlias);
            builderTemplate.buildDirectoryDataDoc(config, javaProjectBuilder, apiDocList, "html/dict.html", DICT_HTML, indexAlias);
            builderTemplate.buildSearchJs(config, javaProjectBuilder, apiDocList, "js/search.js.btl");
        }
    }

    private static void buildDoc(DocBuilderTemplate builderTemplate, List<ApiDoc> apiDocList, ApiConfig config, JavaProjectBuilder javaProjectBuilder, String template, String indexHtml) {
        FileUtil.mkdirs((String)config.getOutPath());
        int index = 0;
        for (ApiDoc doc : apiDocList) {
            if (index == 0) {
                doc.setAlias(indexHtml);
            }
            builderTemplate.buildDoc(apiDocList, config, javaProjectBuilder, template, doc.getAlias() + ".html", doc, indexHtml);
            ++index;
        }
    }
}

