/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.handler;

import com.power.common.util.StringUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.model.ApiReqParam;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SpringMVCRequestHeaderHandler {
    public List<ApiReqParam> handle(JavaMethod method, ProjectDocConfigBuilder projectBuilder) {
        Map<String, String> constantsMap = projectBuilder.getConstantsMap();
        ArrayList<ApiReqParam> mappingHeaders = new ArrayList<ApiReqParam>();
        List annotations = method.getAnnotations();
        for (Object annotation : annotations) {
            String annotationName = annotation.getType().getValue();
            Object headersObject = annotation.getNamedParameter("headers");
            if (!this.isMapping(annotationName) || Objects.isNull(headersObject)) continue;
            String mappingHeader = StringUtil.removeQuotes((String)headersObject.toString());
            if (!mappingHeader.startsWith("[")) {
                this.processMappingHeaders(mappingHeader, mappingHeaders);
                continue;
            }
            LinkedList headers = (LinkedList)headersObject;
            for (String str : headers) {
                String header = StringUtil.removeQuotes((String)str);
                if (header.startsWith("!")) continue;
                this.processMappingHeaders(header, mappingHeaders);
            }
        }
        ArrayList<ApiReqParam> reqHeaders = new ArrayList<ApiReqParam>();
        block2: for (JavaParameter javaParameter : method.getParameters()) {
            List javaAnnotations = javaParameter.getAnnotations();
            String className = method.getDeclaringClass().getCanonicalName();
            Map<String, String> paramMap = DocUtil.getParamsComments(method, "param", className);
            String paramName = javaParameter.getName();
            for (JavaAnnotation annotation : javaAnnotations) {
                String annotationName = annotation.getType().getValue();
                if (!"RequestHeader".equals(annotationName)) continue;
                ApiReqParam apiReqHeader = new ApiReqParam();
                Map requestHeaderMap = annotation.getNamedParameterMap();
                if (requestHeaderMap.get("value") != null) {
                    String attribute = DocUtil.handleRequestHeaderValue(annotation);
                    String constValue = ((String)requestHeaderMap.get("value")).replaceAll("\"", "");
                    if (StringUtil.isEmpty((String)attribute)) {
                        apiReqHeader.setName(constValue);
                    } else {
                        String value = constantsMap.get(attribute);
                        if (value == null) {
                            apiReqHeader.setName(constValue);
                        } else {
                            apiReqHeader.setName(value);
                        }
                    }
                } else {
                    apiReqHeader.setName(paramName);
                }
                StringBuilder desc = new StringBuilder();
                String comments = paramMap.get(paramName);
                desc.append(comments);
                if (requestHeaderMap.get("defaultValue") != null) {
                    apiReqHeader.setValue(StringUtil.removeQuotes((String)((String)requestHeaderMap.get("defaultValue"))));
                    desc.append("(defaultValue: ").append(StringUtil.removeQuotes((String)((String)requestHeaderMap.get("defaultValue")))).append(")");
                }
                apiReqHeader.setDesc(desc.toString());
                if (requestHeaderMap.get("required") != null) {
                    apiReqHeader.setRequired(!Boolean.FALSE.toString().equals(requestHeaderMap.get("required")));
                } else {
                    apiReqHeader.setRequired(true);
                }
                String typeName = javaParameter.getType().getValue().toLowerCase();
                apiReqHeader.setType(DocClassUtil.processTypeNameForParams(typeName));
                reqHeaders.add(apiReqHeader);
                continue block2;
            }
        }
        List<ApiReqParam> allApiReqHeaders = Stream.of(mappingHeaders, reqHeaders).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        return allApiReqHeaders;
    }

    private boolean isMapping(String annotationName) {
        switch (annotationName) {
            case "GetMapping": 
            case "RequestMapping": 
            case "PostMapping": 
            case "PutMapping": 
            case "PatchMapping": 
            case "DeleteMapping": {
                return true;
            }
        }
        return false;
    }

    public void processMappingHeaders(String header, List<ApiReqParam> mappingHeaders) {
        if (header.contains("!=")) {
            String headerName = header.substring(0, header.indexOf("!"));
            ApiReqParam apiReqHeader = ApiReqParam.builder().setName(headerName).setRequired(true).setValue(null).setDesc("header condition").setType("string");
            mappingHeaders.add(apiReqHeader);
        } else {
            String headerName;
            String headerValue = null;
            if (header.contains("=")) {
                int index = header.indexOf("=");
                headerName = header.substring(0, index);
                headerValue = header.substring(index + 1);
            } else {
                headerName = header;
            }
            ApiReqParam apiReqHeader = ApiReqParam.builder().setName(headerName).setRequired(true).setValue(headerValue).setDesc("header condition").setType("string");
            mappingHeaders.add(apiReqHeader);
        }
    }
}

