/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.model;

import com.power.common.util.CollectionUtil;
import com.power.doc.constants.DocLanguage;
import com.power.doc.model.ApiConstant;
import com.power.doc.model.ApiDataDictionary;
import com.power.doc.model.ApiErrorCode;
import com.power.doc.model.ApiErrorCodeDictionary;
import com.power.doc.model.ApiGroup;
import com.power.doc.model.ApiObjectReplacement;
import com.power.doc.model.ApiReqParam;
import com.power.doc.model.BodyAdvice;
import com.power.doc.model.CustomField;
import com.power.doc.model.RevisionLog;
import com.power.doc.model.SourceCodePath;
import com.power.doc.model.rpc.RpcApiDependency;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ApiConfig {
    private String serverUrl;
    private String serverEnv;
    private String pathPrefix = "";
    private boolean isStrict;
    private boolean allInOne;
    private String outPath;
    private List<SourceCodePath> sourceCodePaths;
    private List<ApiReqParam> requestHeaders;
    private List<ApiReqParam> requestParams;
    private boolean coverOld;
    private List<CustomField> customResponseFields;
    private List<CustomField> customRequestFields;
    private List<ApiErrorCode> errorCodes;
    private String packageFilters;
    private List<RevisionLog> revisionLogs;
    private boolean md5EncryptedHtmlName;
    private DocLanguage language;
    private boolean adoc;
    private List<ApiDataDictionary> dataDictionaries;
    private transient ClassLoader classLoader;
    private List<ApiErrorCodeDictionary> errorCodeDictionaries;
    private List<ApiObjectReplacement> apiObjectReplacements;
    private List<RpcApiDependency> rpcApiDependencies;
    private List<ApiConstant> apiConstants;
    private String group;
    private String projectName;
    private String projectCName;
    private boolean skipTransientField = true;
    private boolean showAuthor = true;
    private boolean requestFieldToUnderline;
    private boolean responseFieldToUnderline;
    private boolean sortByTitle;
    private Boolean showJavaType = Boolean.FALSE;
    private Boolean inlineEnum = Boolean.FALSE;
    private String rpcConsumerConfig;
    private int recursionLimit = 7;
    private boolean requestExample = Boolean.TRUE;
    private boolean responseExample = Boolean.TRUE;
    private String allInOneDocFileName;
    private boolean paramsDataToTree;
    private List<String> ignoreRequestParams;
    private boolean displayActualType;
    private BodyAdvice responseBodyAdvice;
    private BodyAdvice requestBodyAdvice;
    private String style;
    private String highlightStyleLink;
    private boolean createDebugPage;
    private String urlSuffix;
    private String appKey;
    private String secret;
    private String appToken;
    private String openUrl;
    private String debugEnvName;
    private String debugEnvUrl;
    private boolean tornaDebug = true;
    private String author;
    private String framework;
    private List<ApiGroup> groups;
    private Boolean replace;
    private boolean requestParamsTable = Boolean.TRUE;
    private boolean responseParamsTable = Boolean.TRUE;

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ApiConfig setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public boolean isTornaDebug() {
        return this.tornaDebug;
    }

    public void setTornaDebug(boolean tornaDebug) {
        this.tornaDebug = tornaDebug;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public String getOpenUrl() {
        return this.openUrl;
    }

    public void setOpenUrl(String openUrl) {
        this.openUrl = openUrl;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public void setStrict(boolean strict) {
        this.isStrict = strict;
    }

    public String getOutPath() {
        return this.outPath;
    }

    public void setOutPath(String outPath) {
        this.outPath = outPath;
    }

    public List<ApiReqParam> getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(List<ApiReqParam> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public void setRequestHeaders(ApiReqParam ... requestHeaders) {
        this.requestHeaders = CollectionUtil.asList((Object[])requestHeaders);
        this.requestHeaders.forEach(header -> header.setDesc(header.getDesc() + "(Global)"));
    }

    public List<ApiGroup> getGroups() {
        return this.groups;
    }

    public ApiConfig setGroups(List<ApiGroup> groups) {
        this.groups = groups;
        return this;
    }

    public ApiConfig setGroups(ApiGroup ... groups) {
        this.groups = CollectionUtil.asList((Object[])groups);
        return this;
    }

    public List<ApiReqParam> getRequestParams() {
        return this.requestParams;
    }

    public ApiConfig setRequestParams(List<ApiReqParam> requestParams) {
        this.requestParams = requestParams;
        return this;
    }

    public void setRequestParams(ApiReqParam ... requestParams) {
        this.requestParams = CollectionUtil.asList((Object[])requestParams);
        this.requestParams.forEach(param -> param.setDesc(param.getDesc() + "(Global)"));
    }

    public List<CustomField> getCustomResponseFields() {
        return this.customResponseFields;
    }

    public void setCustomResponseFields(List<CustomField> customResponseFields) {
        this.customResponseFields = customResponseFields;
    }

    public void setCustomResponseFields(CustomField ... customResponseFields) {
        this.customResponseFields = CollectionUtil.asList((Object[])customResponseFields);
    }

    public List<ApiErrorCode> getErrorCodes() {
        return this.errorCodes;
    }

    public void setErrorCodes(List<ApiErrorCode> errorCodes) {
        this.errorCodes = errorCodes;
    }

    public List<SourceCodePath> getSourceCodePaths() {
        return this.sourceCodePaths;
    }

    public void setSourceCodePaths(List<SourceCodePath> sourceCodePaths) {
        this.sourceCodePaths = sourceCodePaths;
    }

    public void setSourceCodePaths(SourceCodePath ... sourcePaths) {
        this.sourceCodePaths = CollectionUtil.asList((Object[])sourcePaths);
    }

    public boolean isAllInOne() {
        return this.allInOne;
    }

    public void setAllInOne(boolean allInOne) {
        this.allInOne = allInOne;
    }

    public String getPackageFilters() {
        return this.packageFilters;
    }

    public void setPackageFilters(String packageFilters) {
        this.packageFilters = packageFilters;
    }

    public List<RevisionLog> getRevisionLogs() {
        return this.revisionLogs;
    }

    public void setRevisionLogs(List<RevisionLog> revisionLogs) {
        this.revisionLogs = revisionLogs;
    }

    public void setRevisionLogs(RevisionLog ... revisionLogs) {
        this.revisionLogs = CollectionUtil.asList((Object[])revisionLogs);
    }

    public boolean isMd5EncryptedHtmlName() {
        return this.md5EncryptedHtmlName;
    }

    public void setMd5EncryptedHtmlName(boolean md5EncryptedHtmlName) {
        this.md5EncryptedHtmlName = md5EncryptedHtmlName;
    }

    public DocLanguage getLanguage() {
        return this.language;
    }

    public void setLanguage(DocLanguage language) {
        this.language = language;
    }

    public boolean isAdoc() {
        return this.adoc;
    }

    public void setAdoc(boolean adoc) {
        this.adoc = adoc;
    }

    public List<ApiDataDictionary> getDataDictionaries() {
        return this.dataDictionaries;
    }

    public void setDataDictionaries(List<ApiDataDictionary> dataDictionaries) {
        this.dataDictionaries = dataDictionaries;
    }

    public void setDataDictionaries(ApiDataDictionary ... dataDictConfigs) {
        this.dataDictionaries = CollectionUtil.asList((Object[])dataDictConfigs);
    }

    public ApiDataDictionary getDataDictionary(String enumClassName) {
        if (Objects.isNull(this.dataDictionaries)) {
            return null;
        }
        return this.dataDictionaries.stream().filter(apiDataDictionary -> {
            boolean equalsName = enumClassName.equalsIgnoreCase(apiDataDictionary.getEnumClassName());
            Set<Class<? extends Enum>> enumImplementSet = apiDataDictionary.getEnumImplementSet();
            if (CollectionUtil.isEmpty(enumImplementSet)) {
                return equalsName;
            }
            Set collect = enumImplementSet.stream().map(Class::getName).collect(Collectors.toSet());
            return equalsName || collect.contains(enumClassName);
        }).findFirst().orElse(null);
    }

    public List<ApiErrorCodeDictionary> getErrorCodeDictionaries() {
        return this.errorCodeDictionaries;
    }

    public void setErrorCodeDictionaries(List<ApiErrorCodeDictionary> errorCodeDictionaries) {
        this.errorCodeDictionaries = errorCodeDictionaries;
    }

    public void setErrorCodeDictionaries(ApiErrorCodeDictionary ... errorCodeDictConfigs) {
        this.errorCodeDictionaries = CollectionUtil.asList((Object[])errorCodeDictConfigs);
    }

    public List<ApiObjectReplacement> getApiObjectReplacements() {
        return this.apiObjectReplacements;
    }

    public void setApiObjectReplacements(List<ApiObjectReplacement> apiObjectReplacements) {
        this.apiObjectReplacements = apiObjectReplacements;
    }

    public void setApiObjectReplacements(ApiObjectReplacement ... apiObjectReplaces) {
        this.apiObjectReplacements = CollectionUtil.asList((Object[])apiObjectReplaces);
    }

    public List<RpcApiDependency> getRpcApiDependencies() {
        return this.rpcApiDependencies;
    }

    public void setRpcApiDependencies(List<RpcApiDependency> rpcApiDependencies) {
        this.rpcApiDependencies = rpcApiDependencies;
    }

    public void setRpcApiDependencies(RpcApiDependency ... rpcApiDependencies) {
        this.rpcApiDependencies = CollectionUtil.asList((Object[])rpcApiDependencies);
    }

    public List<ApiConstant> getApiConstants() {
        return this.apiConstants;
    }

    public void setApiConstants(List<ApiConstant> apiConstants) {
        this.apiConstants = apiConstants;
    }

    public void setApiConstants(ApiConstant ... apiConstants) {
        this.apiConstants = CollectionUtil.asList((Object[])apiConstants);
    }

    public boolean isCoverOld() {
        return this.coverOld;
    }

    public void setCoverOld(boolean coverOld) {
        this.coverOld = coverOld;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCName() {
        return this.projectCName;
    }

    public void setProjectCName(String projectCName) {
        this.projectCName = projectCName;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isSkipTransientField() {
        return this.skipTransientField;
    }

    public void setSkipTransientField(boolean skipTransientField) {
        this.skipTransientField = skipTransientField;
    }

    public boolean isShowAuthor() {
        return this.showAuthor;
    }

    public void setShowAuthor(boolean showAuthor) {
        this.showAuthor = showAuthor;
    }

    public boolean isRequestFieldToUnderline() {
        return this.requestFieldToUnderline;
    }

    public void setRequestFieldToUnderline(boolean requestFieldToUnderline) {
        this.requestFieldToUnderline = requestFieldToUnderline;
    }

    public boolean isResponseFieldToUnderline() {
        return this.responseFieldToUnderline;
    }

    public void setResponseFieldToUnderline(boolean responseFieldToUnderline) {
        this.responseFieldToUnderline = responseFieldToUnderline;
    }

    public boolean isSortByTitle() {
        return this.sortByTitle;
    }

    public void setSortByTitle(boolean sortByTitle) {
        this.sortByTitle = sortByTitle;
    }

    public Boolean getShowJavaType() {
        return this.showJavaType;
    }

    public void setShowJavaType(Boolean showJavaType) {
        this.showJavaType = showJavaType;
    }

    public String getRpcConsumerConfig() {
        return this.rpcConsumerConfig;
    }

    public void setRpcConsumerConfig(String rpcConsumerConfig) {
        this.rpcConsumerConfig = rpcConsumerConfig;
    }

    public Boolean getInlineEnum() {
        return this.inlineEnum;
    }

    public void setInlineEnum(Boolean inlineEnum) {
        this.inlineEnum = inlineEnum;
    }

    public int getRecursionLimit() {
        return this.recursionLimit;
    }

    public void setRecursionLimit(int recursionLimit) {
        this.recursionLimit = recursionLimit;
    }

    public boolean isRequestExample() {
        return this.requestExample;
    }

    public void setRequestExample(boolean requestExample) {
        this.requestExample = requestExample;
    }

    public boolean isResponseExample() {
        return this.responseExample;
    }

    public void setResponseExample(boolean responseExample) {
        this.responseExample = responseExample;
    }

    public String getAllInOneDocFileName() {
        return this.allInOneDocFileName;
    }

    public void setAllInOneDocFileName(String allInOneDocFileName) {
        this.allInOneDocFileName = allInOneDocFileName;
    }

    public boolean isParamsDataToTree() {
        return this.paramsDataToTree;
    }

    public void setParamsDataToTree(boolean paramsDataToTree) {
        this.paramsDataToTree = paramsDataToTree;
    }

    public List<String> getIgnoreRequestParams() {
        return this.ignoreRequestParams;
    }

    public void setIgnoreRequestParams(List<String> ignoreRequestParams) {
        this.ignoreRequestParams = ignoreRequestParams;
    }

    public boolean isDisplayActualType() {
        return this.displayActualType;
    }

    public void setDisplayActualType(boolean displayActualType) {
        this.displayActualType = displayActualType;
    }

    public BodyAdvice getResponseBodyAdvice() {
        return this.responseBodyAdvice;
    }

    public void setResponseBodyAdvice(BodyAdvice responseBodyAdvice) {
        this.responseBodyAdvice = responseBodyAdvice;
    }

    public BodyAdvice getRequestBodyAdvice() {
        return this.requestBodyAdvice;
    }

    public void setRequestBodyAdvice(BodyAdvice requestBodyAdvice) {
        this.requestBodyAdvice = requestBodyAdvice;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean isCreateDebugPage() {
        return this.createDebugPage;
    }

    public void setCreateDebugPage(boolean createDebugPage) {
        this.createDebugPage = createDebugPage;
    }

    public String getDebugEnvName() {
        return this.debugEnvName;
    }

    public void setDebugEnvName(String debugEnvName) {
        this.debugEnvName = debugEnvName;
    }

    public String getDebugEnvUrl() {
        return this.debugEnvUrl;
    }

    public void setDebugEnvUrl(String debugEnvUrl) {
        this.debugEnvUrl = debugEnvUrl;
    }

    public String getUrlSuffix() {
        return this.urlSuffix;
    }

    public void setUrlSuffix(String urlSuffix) {
        this.urlSuffix = urlSuffix;
    }

    public List<CustomField> getCustomRequestFields() {
        return this.customRequestFields;
    }

    public ApiConfig setCustomRequestFields(List<CustomField> customRequestFields) {
        this.customRequestFields = customRequestFields;
        return this;
    }

    public void setCustomRequestFields(CustomField ... customRequestFields) {
        this.customRequestFields = CollectionUtil.asList((Object[])customRequestFields);
    }

    public String getFramework() {
        return this.framework;
    }

    public void setFramework(String framework) {
        this.framework = framework;
    }

    public Boolean getReplace() {
        return this.replace;
    }

    public void setReplace(Boolean replace) {
        this.replace = replace;
    }

    public boolean isRequestParamsTable() {
        return this.requestParamsTable;
    }

    public void setRequestParamsTable(boolean requestParamsTable) {
        this.requestParamsTable = requestParamsTable;
    }

    public boolean isResponseParamsTable() {
        return this.responseParamsTable;
    }

    public void setResponseParamsTable(boolean responseParamsTable) {
        this.responseParamsTable = responseParamsTable;
    }

    public String getHighlightStyleLink() {
        return this.highlightStyleLink;
    }

    public void setHighlightStyleLink(String highlightStyleLink) {
        this.highlightStyleLink = highlightStyleLink;
    }

    public String getServerEnv() {
        return this.serverEnv;
    }

    public void setServerEnv(String serverEnv) {
        this.serverEnv = serverEnv;
    }
}

