/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.power.doc.model.ApiReqParam;
import com.power.doc.model.FormData;
import com.power.doc.model.request.CurlRequest;
import java.util.List;
import java.util.Objects;

public class CurlUtil {
    public static String toCurl(CurlRequest request) {
        List<FormData> fileFormDataList;
        if (Objects.isNull(request)) {
            return "";
        }
        String methodType = request.getType();
        if (Objects.nonNull(methodType) && methodType.contains(".")) {
            methodType = methodType.substring(methodType.indexOf(".") + 1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("curl");
        sb.append(" -X");
        sb.append(" ").append(methodType);
        if (request.getUrl().indexOf("https") == 0) {
            sb.append(" -k");
        }
        if (StringUtil.isNotEmpty((String)request.getContentType()) && !"application/x-www-form-urlencoded;charset=UTF-8".equals(request.getContentType())) {
            sb.append(" -H");
            sb.append(" 'Content-Type: ").append(request.getContentType()).append("'");
        }
        if (CollectionUtil.isNotEmpty(request.getReqHeaders())) {
            for (ApiReqParam reqHeader : request.getReqHeaders()) {
                sb.append(" -H");
                if (StringUtil.isEmpty((String)reqHeader.getValue())) {
                    sb.append(" '" + reqHeader.getName() + "'");
                    continue;
                }
                sb.append(" '" + reqHeader.getName() + ':' + reqHeader.getValue() + "'");
            }
        }
        if (CollectionUtil.isNotEmpty(fileFormDataList = request.getFileFormDataList())) {
            fileFormDataList.forEach(file -> sb.append(" -F '").append(file.getKey()).append("='"));
        }
        sb.append(" -i");
        sb.append(" ").append(request.getUrl());
        if (StringUtil.isNotEmpty((String)request.getBody())) {
            sb.append(" --data");
            sb.append(" '" + request.getBody() + "'");
        }
        return sb.toString();
    }
}

