/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder.rpc;

import com.power.common.util.DateTimeUtil;
import com.power.doc.builder.rpc.RpcDocBuilderTemplate;
import com.power.doc.helper.JavaProjectBuilderHelper;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.rpc.RpcApiDoc;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;

public class RpcMarkdownBuilder {
    private static final String API_EXTENSION = "Api.md";
    private static final String DATE_FORMAT = "yyyyMMddHHmm";

    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = JavaProjectBuilderHelper.create();
        RpcMarkdownBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig apiConfig, JavaProjectBuilder javaProjectBuilder) {
        apiConfig.setAdoc(false);
        RpcDocBuilderTemplate builderTemplate = new RpcDocBuilderTemplate();
        List<RpcApiDoc> apiDocList = builderTemplate.getRpcApiDoc(apiConfig, javaProjectBuilder);
        if (apiConfig.isAllInOne()) {
            String version = apiConfig.isCoverOld() ? "" : "-V" + DateTimeUtil.long2Str((long)System.currentTimeMillis(), (String)DATE_FORMAT);
            String docName = builderTemplate.allInOneDocName(apiConfig, "rpc-all" + version, ".md");
            builderTemplate.buildAllInOne(apiDocList, apiConfig, javaProjectBuilder, "dubbo/DubboAllInOne.md", docName);
        } else {
            builderTemplate.buildApiDoc(apiDocList, apiConfig, "dubbo/Dubbo.md", API_EXTENSION);
            builderTemplate.buildErrorCodeDoc(apiConfig, "ErrorCodeList.md", "ErrorCodeList.md", javaProjectBuilder);
        }
    }
}

