/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.constants;

import com.power.common.util.StringUtil;

public enum FrameworkEnum {
    DUBBO("dubbo", "com.power.doc.template.RpcDocBuildTemplate"),
    SPRING("spring", "com.power.doc.template.SpringBootDocBuildTemplate"),
    SOLON("solon", "com.power.doc.template.SolonDocBuildTemplate"),
    JAX_RS("JAX-RS", "com.power.doc.template.JaxrsDocBuildTemplate");

    private final String framework;
    private final String className;

    private FrameworkEnum(String framework, String className) {
        this.framework = framework;
        this.className = className;
    }

    public static String getClassNameByFramework(String framework) {
        String className = "";
        if (StringUtil.isEmpty((String)framework)) {
            return className;
        }
        for (FrameworkEnum frameworkEnum : FrameworkEnum.values()) {
            if (!frameworkEnum.framework.equalsIgnoreCase(framework)) continue;
            className = frameworkEnum.className;
            break;
        }
        return className;
    }

    public String getFramework() {
        return this.framework;
    }

    public String getClassName() {
        return this.className;
    }
}

