/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.filter;

import com.power.doc.filter.BoxReturnFilter;
import com.power.doc.filter.DefaultReturnFilter;
import com.power.doc.filter.ReturnTypeFilter;
import com.power.doc.filter.WebFluxReturnFilter;
import com.power.doc.model.ApiReturn;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ReturnTypeProcessor {
    private List<ReturnTypeFilter> filters = new ArrayList<ReturnTypeFilter>();
    private String typeName;

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public ApiReturn process() {
        this.filters.add(new WebFluxReturnFilter());
        this.filters.add(new BoxReturnFilter());
        this.filters.add(new DefaultReturnFilter());
        for (ReturnTypeFilter filter : this.filters) {
            ApiReturn apiReturn = filter.doFilter(this.typeName);
            if (!Objects.nonNull(apiReturn)) continue;
            return apiReturn;
        }
        return null;
    }
}

