/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.template;

import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.Methods;
import com.power.doc.constants.SpringMvcRequestAnnotationsEnum;
import com.power.doc.handler.SpringMVCRequestHeaderHandler;
import com.power.doc.handler.SpringMVCRequestMappingHandler;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiReqParam;
import com.power.doc.model.annotation.EntryAnnotation;
import com.power.doc.model.annotation.FrameworkAnnotations;
import com.power.doc.model.annotation.HeaderAnnotation;
import com.power.doc.model.annotation.MappingAnnotation;
import com.power.doc.model.annotation.PathVariableAnnotation;
import com.power.doc.model.annotation.RequestBodyAnnotation;
import com.power.doc.model.annotation.RequestParamAnnotation;
import com.power.doc.model.request.RequestMapping;
import com.power.doc.template.IDocBuildTemplate;
import com.power.doc.template.IRestDocTemplate;
import com.power.doc.utils.JavaClassValidateUtil;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SpringBootDocBuildTemplate
implements IDocBuildTemplate<ApiDoc>,
IRestDocTemplate {
    @Override
    public List<ApiDoc> getApiData(ProjectDocConfigBuilder projectBuilder) {
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        List<ApiReqParam> configApiReqParams = Stream.of(apiConfig.getRequestHeaders(), apiConfig.getRequestParams()).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        FrameworkAnnotations frameworkAnnotations = this.registeredAnnotations();
        List<ApiDoc> apiDocList = this.processApiData(projectBuilder, frameworkAnnotations, configApiReqParams, new SpringMVCRequestMappingHandler(), new SpringMVCRequestHeaderHandler());
        if (apiConfig.isSortByTitle()) {
            Collections.sort(apiDocList);
        }
        return apiDocList;
    }

    @Override
    public boolean ignoreReturnObject(String typeName, List<String> ignoreParams) {
        return JavaClassValidateUtil.isMvcIgnoreParams(typeName, ignoreParams);
    }

    @Override
    public FrameworkAnnotations registeredAnnotations() {
        FrameworkAnnotations annotations = FrameworkAnnotations.builder();
        HeaderAnnotation headerAnnotation = HeaderAnnotation.builder().setAnnotationName("RequestHeader").setValueProp("value").setDefaultValueProp("defaultValue").setRequiredProp("required");
        annotations.setHeaderAnnotation(headerAnnotation);
        HashMap<String, EntryAnnotation> entryAnnotations = new HashMap<String, EntryAnnotation>();
        EntryAnnotation controllerAnnotation = EntryAnnotation.builder().setAnnotationName("Controller").setAnnotationFullyName("Controller");
        entryAnnotations.put(controllerAnnotation.getAnnotationName(), controllerAnnotation);
        EntryAnnotation restController = EntryAnnotation.builder().setAnnotationName("RestController");
        entryAnnotations.put(restController.getAnnotationName(), restController);
        annotations.setEntryAnnotations(entryAnnotations);
        RequestBodyAnnotation bodyAnnotation = RequestBodyAnnotation.builder().setAnnotationName("RequestBody").setAnnotationFullyName("org.springframework.web.bind.annotation.RequestBody");
        annotations.setRequestBodyAnnotation(bodyAnnotation);
        RequestParamAnnotation requestAnnotation = RequestParamAnnotation.builder().setAnnotationName("RequestParam").setDefaultValueProp("defaultValue").setRequiredProp("required");
        annotations.setRequestParamAnnotation(requestAnnotation);
        PathVariableAnnotation pathVariableAnnotation = PathVariableAnnotation.builder().setAnnotationName("PathVariable").setDefaultValueProp("defaultValue").setRequiredProp("required");
        annotations.setPathVariableAnnotation(pathVariableAnnotation);
        HashMap<String, MappingAnnotation> mappingAnnotations = new HashMap<String, MappingAnnotation>();
        MappingAnnotation requestMappingAnnotation = MappingAnnotation.builder().setAnnotationName("RequestMapping").setConsumesProp("consumes").setProducesProp("produces").setMethodProp("method").setParamsProp("params").setScope("class", "method").setPathProps("value", "name", "path");
        mappingAnnotations.put(requestMappingAnnotation.getAnnotationName(), requestMappingAnnotation);
        MappingAnnotation postMappingAnnotation = MappingAnnotation.builder().setAnnotationName("PostMapping").setConsumesProp("consumes").setProducesProp("produces").setMethodProp("method").setParamsProp("params").setMethodType(Methods.POST.getValue()).setPathProps("value", "name", "path");
        mappingAnnotations.put(postMappingAnnotation.getAnnotationName(), postMappingAnnotation);
        MappingAnnotation getMappingAnnotation = MappingAnnotation.builder().setAnnotationName("GetMapping").setConsumesProp("consumes").setProducesProp("produces").setMethodProp("method").setParamsProp("params").setMethodType(Methods.GET.getValue()).setPathProps("value", "name", "path");
        mappingAnnotations.put(getMappingAnnotation.getAnnotationName(), getMappingAnnotation);
        MappingAnnotation putMappingAnnotation = MappingAnnotation.builder().setAnnotationName("PutMapping").setConsumesProp("consumes").setProducesProp("produces").setParamsProp("params").setMethodProp("method").setMethodType(Methods.PUT.getValue()).setPathProps("value", "name", "path");
        mappingAnnotations.put(putMappingAnnotation.getAnnotationName(), putMappingAnnotation);
        MappingAnnotation patchMappingAnnotation = MappingAnnotation.builder().setAnnotationName("PatchMapping").setConsumesProp("consumes").setProducesProp("produces").setMethodProp("method").setParamsProp("params").setMethodType(Methods.PATCH.getValue()).setPathProps("value", "name", "path");
        mappingAnnotations.put(patchMappingAnnotation.getAnnotationName(), patchMappingAnnotation);
        MappingAnnotation deleteMappingAnnotation = MappingAnnotation.builder().setAnnotationName("DeleteMapping").setConsumesProp("consumes").setProducesProp("produces").setMethodProp("method").setParamsProp("params").setMethodType(Methods.DELETE.getValue()).setPathProps("value", "name", "path");
        mappingAnnotations.put(deleteMappingAnnotation.getAnnotationName(), deleteMappingAnnotation);
        MappingAnnotation feignClientAnnotation = MappingAnnotation.builder().setAnnotationName("FeignClient").setAnnotationFullyName("org.springframework.cloud.netflix.feign.FeignClient");
        mappingAnnotations.put(feignClientAnnotation.getAnnotationName(), feignClientAnnotation);
        annotations.setMappingAnnotations(mappingAnnotations);
        return annotations;
    }

    @Override
    public boolean isEntryPoint(JavaClass javaClass, FrameworkAnnotations frameworkAnnotations) {
        if (javaClass.isAnnotation() || javaClass.isEnum()) {
            return false;
        }
        List docletTags = javaClass.getTags();
        for (DocletTag docletTag : docletTags) {
            String value = docletTag.getName();
            if (!"restApi".equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> listMvcRequestAnnotations() {
        return SpringMvcRequestAnnotationsEnum.listSpringMvcRequestAnnotations();
    }

    @Override
    public void requestMappingPostProcess(JavaClass javaClass, JavaMethod method, RequestMapping requestMapping) {
    }

    @Override
    public boolean ignoreMvcParamWithAnnotation(String annotation) {
        return JavaClassValidateUtil.ignoreSpringMvcParamWithAnnotation(annotation);
    }
}

