/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc.internal.parser;

import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.FieldJavadoc;
import com.github.therapi.runtimejavadoc.MethodJavadoc;
import com.github.therapi.runtimejavadoc.OtherJavadoc;
import com.github.therapi.runtimejavadoc.ParamJavadoc;
import com.github.therapi.runtimejavadoc.SeeAlsoJavadoc;
import com.github.therapi.runtimejavadoc.ThrowsJavadoc;
import com.github.therapi.runtimejavadoc.internal.parser.BlockTag;
import com.github.therapi.runtimejavadoc.internal.parser.CommentParser;
import com.github.therapi.runtimejavadoc.internal.parser.ParsedJavadoc;
import com.github.therapi.runtimejavadoc.internal.parser.SeeAlsoParser;
import com.github.therapi.runtimejavadoc.internal.parser.ThrowsTagParser;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class JavadocParser {
    private static final Pattern blockSeparator = Pattern.compile("^\\s*@(?=\\S)", 8);
    private static final Pattern whitespace = Pattern.compile("\\s");

    private static ParamJavadoc parseParam(BlockTag t, String owningClass) {
        String[] paramNameAndComment = whitespace.split(t.value, 2);
        String paramName = paramNameAndComment[0];
        String paramComment = paramNameAndComment.length == 1 ? "" : paramNameAndComment[1];
        return new ParamJavadoc(paramName, CommentParser.parse(owningClass, paramComment));
    }

    public static ClassJavadoc parseClassJavadoc(String className, String javadoc, List<FieldJavadoc> fields, List<FieldJavadoc> enumConstants, List<MethodJavadoc> methods, List<MethodJavadoc> constructors) {
        ParsedJavadoc parsed = JavadocParser.parse(javadoc);
        ArrayList<OtherJavadoc> otherDocs = new ArrayList<OtherJavadoc>();
        ArrayList<SeeAlsoJavadoc> seeAlsoDocs = new ArrayList<SeeAlsoJavadoc>();
        ArrayList<ParamJavadoc> paramDocs = new ArrayList<ParamJavadoc>();
        for (BlockTag t : parsed.getBlockTags()) {
            if (t.name.equals("param")) {
                paramDocs.add(JavadocParser.parseParam(t, className));
                continue;
            }
            if (t.name.equals("see")) {
                SeeAlsoJavadoc seeAlso = SeeAlsoParser.parseSeeAlso(className, t.value);
                if (seeAlso == null) continue;
                seeAlsoDocs.add(seeAlso);
                continue;
            }
            otherDocs.add(new OtherJavadoc(t.name, CommentParser.parse(className, t.value)));
        }
        return new ClassJavadoc(className, CommentParser.parse(className, parsed.getDescription()), fields, enumConstants, methods, constructors, otherDocs, seeAlsoDocs, paramDocs);
    }

    public static FieldJavadoc parseFieldJavadoc(String owningClass, String fieldName, String javadoc) {
        ParsedJavadoc parsed = JavadocParser.parse(javadoc);
        ArrayList<OtherJavadoc> otherDocs = new ArrayList<OtherJavadoc>();
        ArrayList<SeeAlsoJavadoc> seeAlsoDocs = new ArrayList<SeeAlsoJavadoc>();
        for (BlockTag t : parsed.getBlockTags()) {
            if (t.name.equals("see")) {
                SeeAlsoJavadoc seeAlso = SeeAlsoParser.parseSeeAlso(owningClass, t.value);
                if (seeAlso == null) continue;
                seeAlsoDocs.add(seeAlso);
                continue;
            }
            otherDocs.add(new OtherJavadoc(t.name, CommentParser.parse(owningClass, t.value)));
        }
        return new FieldJavadoc(fieldName, CommentParser.parse(owningClass, parsed.getDescription()), (List<OtherJavadoc>)otherDocs, (List<SeeAlsoJavadoc>)seeAlsoDocs);
    }

    public static MethodJavadoc parseMethodJavadoc(String owningClass, String methodName, List<String> paramTypes, String javadoc) {
        ParsedJavadoc parsed = JavadocParser.parse(javadoc);
        ArrayList<OtherJavadoc> otherDocs = new ArrayList<OtherJavadoc>();
        ArrayList<SeeAlsoJavadoc> seeAlsoDocs = new ArrayList<SeeAlsoJavadoc>();
        ArrayList<ParamJavadoc> paramDocs = new ArrayList<ParamJavadoc>();
        ArrayList<ThrowsJavadoc> throwsDocs = new ArrayList<ThrowsJavadoc>();
        Comment returns = null;
        for (BlockTag t : parsed.getBlockTags()) {
            if (t.name.equals("param")) {
                paramDocs.add(JavadocParser.parseParam(t, owningClass));
                continue;
            }
            if (t.name.equals("return")) {
                returns = CommentParser.parse(owningClass, t.value);
                continue;
            }
            if (t.name.equals("see")) {
                SeeAlsoJavadoc seeAlso = SeeAlsoParser.parseSeeAlso(owningClass, t.value);
                if (seeAlso == null) continue;
                seeAlsoDocs.add(seeAlso);
                continue;
            }
            if (t.name.equals("throws") || t.name.equals("exception")) {
                ThrowsJavadoc throwsDoc = ThrowsTagParser.parseTag(owningClass, t.value);
                if (throwsDoc == null) continue;
                throwsDocs.add(throwsDoc);
                continue;
            }
            otherDocs.add(new OtherJavadoc(t.name, CommentParser.parse(owningClass, t.value)));
        }
        return new MethodJavadoc(methodName, paramTypes, CommentParser.parse(owningClass, parsed.getDescription()), paramDocs, throwsDocs, otherDocs, returns, seeAlsoDocs);
    }

    private static ParsedJavadoc parse(String javadoc) {
        String[] blocks = blockSeparator.split(javadoc);
        ParsedJavadoc result = new ParsedJavadoc();
        result.description = blocks[0].trim();
        for (int i = 1; i < blocks.length; ++i) {
            result.blockTags.add(JavadocParser.parseBlockTag(blocks[i]));
        }
        return result;
    }

    private static BlockTag parseBlockTag(String block) {
        String[] s = whitespace.split(block.trim(), 2);
        String name = s[0];
        String value = s.length > 1 ? s[1] : "";
        return new BlockTag(name, value);
    }
}

