/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain.proto;

import com.github.tobato.fastdfs.domain.proto.ProtoHead;
import com.github.tobato.fastdfs.domain.proto.mapper.FdfsParamMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.springframework.core.GenericTypeResolver;

public abstract class FdfsResponse<T> {
    protected ProtoHead head;
    protected final Class<T> genericType = GenericTypeResolver.resolveTypeArgument(this.getClass(), FdfsResponse.class);

    protected long getContentLength() {
        return this.head.getContentLength();
    }

    public T decode(ProtoHead head, InputStream in, Charset charset) throws IOException {
        this.head = head;
        return this.decodeContent(in, charset);
    }

    public T decodeContent(InputStream in, Charset charset) throws IOException {
        if (this.getContentLength() > 0L) {
            byte[] bytes = new byte[(int)this.getContentLength()];
            int contentSize = in.read(bytes);
            if ((long)contentSize != this.getContentLength()) {
                throw new IOException("\u8bfb\u53d6\u5230\u7684\u6570\u636e\u957f\u5ea6\u4e0e\u534f\u8bae\u957f\u5ea6\u4e0d\u7b26");
            }
            return FdfsParamMapper.map(bytes, this.genericType, charset);
        }
        return null;
    }
}

