/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty94;

import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.http.ssl.ApacheHttpHostNameMatcher;
import com.github.tomakehurst.wiremock.http.ssl.CertificateGeneratingX509ExtendedKeyManager;
import com.github.tomakehurst.wiremock.http.ssl.DynamicKeyStore;
import com.github.tomakehurst.wiremock.http.ssl.X509KeyStore;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509ExtendedKeyManager;
import wiremock.org.eclipse.jetty.util.ssl.SslContextFactory;

class CertificateGeneratingSslContextFactory
extends SslContextFactory.Server {
    private final X509KeyStore x509KeyStore;
    private final Notifier notifier;

    CertificateGeneratingSslContextFactory(X509KeyStore x509KeyStore, Notifier notifier) {
        this.x509KeyStore = Objects.requireNonNull(x509KeyStore);
        this.notifier = Objects.requireNonNull(notifier);
    }

    @Override
    protected KeyManager[] getKeyManagers(KeyStore keyStore) throws Exception {
        KeyManager[] managers = super.getKeyManagers(keyStore);
        return (KeyManager[])Arrays.stream(managers).map(manager -> {
            if (manager instanceof X509ExtendedKeyManager) {
                return new CertificateGeneratingX509ExtendedKeyManager((X509ExtendedKeyManager)manager, new DynamicKeyStore(this.x509KeyStore), new ApacheHttpHostNameMatcher(), this.notifier);
            }
            return manager;
        }).toArray(KeyManager[]::new);
    }
}

