/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.validation;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import wiremock.org.xmlunit.XMLUnitException;
import wiremock.org.xmlunit.validation.ValidationHandler;
import wiremock.org.xmlunit.validation.ValidationResult;
import wiremock.org.xmlunit.validation.Validator;

public class JAXPValidator
extends Validator {
    private final String language;
    private final SchemaFactory factory;
    private Schema schema;

    public JAXPValidator(String language) {
        this(language, null);
    }

    public JAXPValidator(String language, SchemaFactory factory) {
        this.language = language;
        this.factory = factory;
    }

    public final void setSchema(Schema s2) {
        this.schema = s2;
    }

    private SchemaFactory getFactory() {
        return this.factory == null ? SchemaFactory.newInstance(this.language) : this.factory;
    }

    @Override
    public ValidationResult validateSchema() {
        ValidationHandler v = new ValidationHandler();
        SchemaFactory f = this.getFactory();
        f.setErrorHandler(v);
        try {
            f.newSchema(this.getSchemaSources());
        }
        catch (SAXParseException e) {
            v.error(e);
        }
        catch (SAXException e) {
            throw new XMLUnitException(e);
        }
        finally {
            f.setErrorHandler(null);
        }
        return v.getResult();
    }

    @Override
    public ValidationResult validateInstance(Source s2) {
        Schema schema;
        try {
            schema = this.getSchema();
        }
        catch (SAXException e) {
            throw new XMLUnitException("The schema is invalid", e);
        }
        ValidationHandler v = new ValidationHandler();
        javax.xml.validation.Validator val = schema.newValidator();
        val.setErrorHandler(v);
        try {
            val.validate(s2);
        }
        catch (SAXParseException e) {
            v.error(e);
        }
        catch (SAXException e) {
            throw new XMLUnitException(e);
        }
        catch (IOException e) {
            throw new XMLUnitException(e);
        }
        return v.getResult();
    }

    private Schema getSchema() throws SAXException {
        if (this.schema != null) {
            return this.schema;
        }
        Source[] sources = this.getSchemaSources();
        return sources.length > 0 ? this.getFactory().newSchema(sources) : this.getFactory().newSchema();
    }
}

