/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.tomakehurst.wiremock.common.ListOrSingle;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.extension.responsetemplating.UrlPath;
import com.github.tomakehurst.wiremock.http.MultiValue;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;

@Deprecated
public class RequestLine {
    private final RequestMethod method;
    private final String scheme;
    private final String host;
    private final int port;
    private final Map<String, ListOrSingle<String>> query;
    private final String url;
    private static final Function<MultiValue, ListOrSingle<String>> TO_TEMPLATE_MODEL = new Function<MultiValue, ListOrSingle<String>>(){

        public ListOrSingle<String> apply(MultiValue input) {
            return ListOrSingle.of(input.values());
        }
    };

    private RequestLine(RequestMethod method, String scheme, String host, int port, String url, Map<String, ListOrSingle<String>> query) {
        this.method = method;
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.url = url;
        this.query = query;
    }

    public static RequestLine fromRequest(Request request) {
        URI url = URI.create(request.getUrl());
        Map<String, QueryParameter> rawQuery = Urls.splitQuery(url);
        Map adaptedQuery = Maps.transformValues(rawQuery, TO_TEMPLATE_MODEL);
        return new RequestLine(request.getMethod(), request.getScheme(), request.getHost(), request.getPort(), request.getUrl(), adaptedQuery);
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public UrlPath getPathSegments() {
        return new UrlPath(this.url);
    }

    public String getPath() {
        return this.getPathSegments().toString();
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, ListOrSingle<String>> getQuery() {
        return this.query;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getBaseUrl() {
        String portPart = this.isStandardPort(this.scheme, this.port) ? "" : ":" + this.port;
        return this.scheme + "://" + this.host + portPart;
    }

    private boolean isStandardPort(String scheme, int port) {
        return scheme.equals("http") && port == 80 || scheme.equals("https") && port == 443;
    }
}

