/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.SilentErrorHandler;
import com.github.tomakehurst.wiremock.common.Xml;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.PathPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.XPathPatternJsonSerializer;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import wiremock.com.fasterxml.jackson.annotation.JsonGetter;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import wiremock.com.google.common.base.MoreObjects;
import wiremock.com.google.common.collect.ImmutableMap;
import wiremock.com.google.common.collect.Sets;
import wiremock.org.custommonkey.xmlunit.SimpleNamespaceContext;
import wiremock.org.custommonkey.xmlunit.XMLUnit;
import wiremock.org.custommonkey.xmlunit.XpathEngine;
import wiremock.org.custommonkey.xmlunit.exceptions.XpathException;

@JsonSerialize(using=XPathPatternJsonSerializer.class)
public class MatchesXPathPattern
extends PathPattern {
    private final Map<String, String> xpathNamespaces;

    public MatchesXPathPattern(String xpath) {
        this(xpath, null, null);
    }

    public MatchesXPathPattern(String xpath, StringValuePattern valuePattern) {
        this(xpath, null, valuePattern);
    }

    public MatchesXPathPattern(String xpath, Map<String, String> namespaces) {
        this(xpath, namespaces, null);
    }

    public MatchesXPathPattern(@JsonProperty(value="matchesXPath") String xpath, @JsonProperty(value="namespaces") Map<String, String> namespaces, @JsonProperty(value="valuePattern") StringValuePattern valuePattern) {
        super(xpath, valuePattern);
        this.xpathNamespaces = namespaces == null || namespaces.isEmpty() ? null : namespaces;
    }

    public MatchesXPathPattern withXPathNamespace(String name, String namespaceUri) {
        ImmutableMap<String, String> namespaceMap = ImmutableMap.builder().putAll(MoreObjects.firstNonNull(this.xpathNamespaces, Collections.emptyMap())).put(name, namespaceUri).build();
        return new MatchesXPathPattern((String)this.expectedValue, namespaceMap);
    }

    public String getMatchesXPath() {
        return (String)this.expectedValue;
    }

    @JsonGetter(value="xPathNamespaces")
    public Map<String, String> getXPathNamespaces() {
        return this.xpathNamespaces;
    }

    @Override
    protected MatchResult isSimpleJsonPathMatch(String value) {
        if (value == null) {
            return MatchResult.noMatch();
        }
        NodeList nodeList = this.findXmlNodesMatching(value);
        return MatchResult.of(nodeList != null && nodeList.getLength() > 0);
    }

    @Override
    protected MatchResult isAdvancedJsonPathMatch(String value) {
        if (value == null) {
            return MatchResult.noMatch();
        }
        NodeList nodeList = this.findXmlNodesMatching(value);
        if (nodeList == null || nodeList.getLength() == 0) {
            return MatchResult.noMatch();
        }
        TreeSet<MatchResult> results = Sets.newTreeSet();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String nodeValue = Xml.toStringValue(node);
            results.add(this.valuePattern.match(nodeValue));
        }
        return (MatchResult)results.last();
    }

    private NodeList findXmlNodesMatching(String value) {
        try {
            DocumentBuilder documentBuilder = Xml.newDocumentBuilderFactory().newDocumentBuilder();
            documentBuilder.setErrorHandler(new SilentErrorHandler());
            Document inDocument = XMLUnit.buildDocument(documentBuilder, new StringReader(value));
            XpathEngine simpleXpathEngine = XMLUnit.newXpathEngine();
            if (this.xpathNamespaces != null) {
                SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext(this.xpathNamespaces);
                simpleXpathEngine.setNamespaceContext(namespaceContext);
            }
            return simpleXpathEngine.getMatchingNodes((String)this.expectedValue, inDocument);
        }
        catch (SAXException e) {
            LocalNotifier.notifier().info(String.format("Warning: failed to parse the XML document. Reason: %s\nXML: %s", e.getMessage(), value));
            return null;
        }
        catch (IOException e) {
            LocalNotifier.notifier().info(e.getMessage());
            return null;
        }
        catch (XpathException e) {
            LocalNotifier.notifier().info("Warning: failed to evaluate the XPath expression " + (String)this.expectedValue);
            return null;
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, NodeList.class);
        }
    }
}

