/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.internal;

import java.util.ArrayList;
import java.util.List;
import wiremock.com.github.jknack.handlebars.internal.HbsParser;
import wiremock.com.github.jknack.handlebars.internal.HbsParserBaseListener;
import wiremock.org.antlr.v4.runtime.CommonToken;

public class MustacheSpec
extends HbsParserBaseListener {
    private boolean nonSpace = false;
    private Boolean hasTag;
    protected StringBuilder line = new StringBuilder();
    private List<CommonToken> spaces = new ArrayList<CommonToken>();

    @Override
    public void enterSpaces(HbsParser.SpacesContext ctx) {
        CommonToken space = (CommonToken)ctx.SPACE().getSymbol();
        this.line.append(space.getText());
        this.spaces.add(space);
    }

    @Override
    public void enterNewline(HbsParser.NewlineContext ctx) {
        CommonToken newline = (CommonToken)ctx.NL().getSymbol();
        this.spaces.add(newline);
        this.stripSpaces();
    }

    @Override
    public void exitTemplate(HbsParser.TemplateContext ctx) {
        this.stripSpaces();
    }

    private void stripSpaces() {
        boolean hasTag;
        boolean bl = hasTag = this.hasTag == null ? false : this.hasTag;
        if (hasTag && !this.nonSpace) {
            for (CommonToken space : this.spaces) {
                space.setChannel(1);
            }
        } else {
            this.spaces.clear();
        }
        this.hasTag = null;
        this.nonSpace = false;
        this.line.setLength(0);
    }

    @Override
    public void enterText(HbsParser.TextContext ctx) {
        this.nonSpace = true;
    }

    @Override
    public void enterBlock(HbsParser.BlockContext ctx) {
        this.hasTag(true);
    }

    @Override
    public void exitBlock(HbsParser.BlockContext ctx) {
        this.hasTag(true);
    }

    @Override
    public void enterComment(HbsParser.CommentContext ctx) {
        this.hasTag(true);
    }

    @Override
    public void exitPartial(HbsParser.PartialContext ctx) {
        this.hasTag(true);
    }

    @Override
    public void enterDelimiters(HbsParser.DelimitersContext ctx) {
        this.hasTag(true);
    }

    @Override
    public void enterUnless(HbsParser.UnlessContext ctx) {
        this.hasTag(true);
    }

    @Override
    public void enterElseBlock(HbsParser.ElseBlockContext ctx) {
        this.hasTag(true);
    }

    @Override
    public void exitUnless(HbsParser.UnlessContext ctx) {
        this.hasTag(true);
    }

    @Override
    public void enterAmpvar(HbsParser.AmpvarContext ctx) {
        this.hasTag(false);
    }

    @Override
    public void enterTvar(HbsParser.TvarContext ctx) {
        this.hasTag(false);
    }

    @Override
    public void enterVar(HbsParser.VarContext ctx) {
        this.hasTag(false);
    }

    private void hasTag(boolean hasTag) {
        if (this.hasTag != Boolean.FALSE) {
            this.hasTag = hasTag;
        }
    }
}

