/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.AssignHelper;
import com.github.jknack.handlebars.helper.ConditionalHelpers;
import com.github.jknack.handlebars.helper.NumberHelper;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestTemplateModel;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.WireMockHelpers;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ResponseTemplateTransformer
extends ResponseDefinitionTransformer {
    public static final String NAME = "response-template";
    private final boolean global;
    private final Handlebars handlebars;

    public ResponseTemplateTransformer(boolean global) {
        this(global, Collections.emptyMap());
    }

    public ResponseTemplateTransformer(boolean global, String helperName, Helper helper) {
        this(global, (Map<String, Helper>)ImmutableMap.of((Object)helperName, (Object)helper));
    }

    public ResponseTemplateTransformer(boolean global, Map<String, Helper> helpers) {
        this(global, new Handlebars(), helpers);
    }

    public ResponseTemplateTransformer(boolean global, Handlebars handlebars, Map<String, Helper> helpers) {
        this.global = global;
        this.handlebars = handlebars;
        for (StringHelpers stringHelpers : StringHelpers.values()) {
            if (stringHelpers.name().equals("now")) continue;
            this.handlebars.registerHelper(stringHelpers.name(), (Helper)stringHelpers);
        }
        for (NumberHelper numberHelper : NumberHelper.values()) {
            this.handlebars.registerHelper(numberHelper.name(), (Helper)numberHelper);
        }
        for (ConditionalHelpers conditionalHelpers : ConditionalHelpers.values()) {
            this.handlebars.registerHelper(conditionalHelpers.name(), (Helper)conditionalHelpers);
        }
        this.handlebars.registerHelper("assign", (Helper)new AssignHelper());
        for (WireMockHelpers wireMockHelpers : WireMockHelpers.values()) {
            this.handlebars.registerHelper(wireMockHelpers.name(), (Helper)wireMockHelpers);
        }
        for (Map.Entry<String, Helper> entry : helpers.entrySet()) {
            this.handlebars.registerHelper(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean applyGlobally() {
        return this.global;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ResponseDefinition transform(Request request, ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
        ResponseDefinitionBuilder newResponseDefBuilder = ResponseDefinitionBuilder.like(responseDefinition);
        final ImmutableMap model = ImmutableMap.builder().put((Object)"parameters", MoreObjects.firstNonNull((Object)parameters, Collections.emptyMap())).put((Object)"request", (Object)RequestTemplateModel.from(request)).build();
        if (responseDefinition.specifiesTextBodyContent()) {
            Template bodyTemplate = this.uncheckedCompileTemplate(responseDefinition.getBody());
            this.applyTemplatedResponseBody(newResponseDefBuilder, (ImmutableMap<String, Object>)model, bodyTemplate);
        } else if (responseDefinition.specifiesBodyFile()) {
            Template filePathTemplate = this.uncheckedCompileTemplate(responseDefinition.getBodyFileName());
            String compiledFilePath = this.uncheckedApplyTemplate(filePathTemplate, model);
            TextFile file = files.getTextFileNamed(compiledFilePath);
            Template bodyTemplate = this.uncheckedCompileTemplate(file.readContentsAsString());
            this.applyTemplatedResponseBody(newResponseDefBuilder, (ImmutableMap<String, Object>)model, bodyTemplate);
        }
        if (responseDefinition.getHeaders() != null) {
            Iterable newResponseHeaders = Iterables.transform(responseDefinition.getHeaders().all(), (Function)new Function<HttpHeader, HttpHeader>(){

                public HttpHeader apply(HttpHeader input) {
                    List newValues = Lists.transform(input.values(), (Function)new Function<String, String>(){

                        public String apply(String input) {
                            Template template = ResponseTemplateTransformer.this.uncheckedCompileTemplate(input);
                            return ResponseTemplateTransformer.this.uncheckedApplyTemplate(template, model);
                        }
                    });
                    return new HttpHeader(input.key(), (Collection<String>)newValues);
                }
            });
            newResponseDefBuilder.withHeaders(new HttpHeaders(newResponseHeaders));
        }
        if (responseDefinition.getProxyBaseUrl() != null) {
            Template proxyBaseUrlTemplate = this.uncheckedCompileTemplate(responseDefinition.getProxyBaseUrl());
            String newProxyBaseUrl = this.uncheckedApplyTemplate(proxyBaseUrlTemplate, model);
            newResponseDefBuilder.proxiedFrom(newProxyBaseUrl);
        }
        return newResponseDefBuilder.build();
    }

    private void applyTemplatedResponseBody(ResponseDefinitionBuilder newResponseDefBuilder, ImmutableMap<String, Object> model, Template bodyTemplate) {
        String newBody = this.uncheckedApplyTemplate(bodyTemplate, model);
        newResponseDefBuilder.withBody(newBody);
    }

    private String uncheckedApplyTemplate(Template template, Object context) {
        try {
            return template.apply(context);
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    private Template uncheckedCompileTemplate(String content) {
        try {
            return this.handlebars.compileInline(content);
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, Template.class);
        }
    }
}

