/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptmavenplugin.mojo;

import com.ulisesbocchio.jasyptmavenplugin.encrypt.EncryptionService;
import com.ulisesbocchio.jasyptmavenplugin.mojo.AbstractValueJasyptMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="encrypt-value", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class EncryptValueMojo
extends AbstractValueJasyptMojo {
    private static final Logger log = LoggerFactory.getLogger(EncryptValueMojo.class);

    @Override
    protected void run(EncryptionService service, String value, String encryptPrefix, String encryptSuffix, String decryptPrefix, String decryptSuffix) throws MojoExecutionException {
        try {
            String actualValue = value.startsWith(decryptPrefix) ? value.substring(decryptPrefix.length(), value.length() - decryptSuffix.length()) : value;
            log.info("Encrypting value " + actualValue);
            String encryptedValue = encryptPrefix + service.encryptValue(actualValue) + encryptSuffix;
            log.info("\n" + encryptedValue);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error Encrypting: " + e.getMessage(), e);
        }
    }
}

