/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.configuration;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import com.ulisesbocchio.jasyptspringboot.environment.EncryptableEnvironment;
import java.util.Optional;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class EnvCopy {
    StandardEnvironment copy = new StandardEnvironment();

    public EnvCopy(ConfigurableEnvironment environment) {
        Optional.ofNullable(environment instanceof EncryptableEnvironment ? ((EncryptableEnvironment)environment).getOriginalPropertySources() : environment.getPropertySources()).ifPresent(sources -> sources.forEach(this::addLast));
    }

    private PropertySource<?> getOriginal(PropertySource<?> propertySource) {
        return propertySource instanceof EncryptablePropertySource ? ((EncryptablePropertySource)propertySource).getDelegate() : propertySource;
    }

    public boolean isAllowed(PropertySource<?> propertySource) {
        PropertySource<?> original = this.getOriginal(propertySource);
        return !original.getClass().getName().equals("org.springframework.boot.context.properties.source.ConfigurationPropertySourcesPropertySource");
    }

    public void addFirst(PropertySource<?> propertySource) {
        if (this.isAllowed(propertySource)) {
            PropertySource<?> original = this.getOriginal(propertySource);
            this.copy.getPropertySources().addFirst(original);
        }
    }

    public void addLast(PropertySource<?> propertySource) {
        if (this.isAllowed(propertySource)) {
            PropertySource<?> original = this.getOriginal(propertySource);
            this.copy.getPropertySources().addLast(original);
        }
    }

    public void addBefore(String relativePropertySourceName, PropertySource<?> propertySource) {
        if (this.isAllowed(propertySource)) {
            PropertySource<?> original = this.getOriginal(propertySource);
            this.copy.getPropertySources().addBefore(relativePropertySourceName, original);
        }
    }

    public void addAfter(String relativePropertySourceName, PropertySource<?> propertySource) {
        if (this.isAllowed(propertySource)) {
            PropertySource<?> original = this.getOriginal(propertySource);
            this.copy.getPropertySources().addAfter(relativePropertySourceName, original);
        }
    }

    public void replace(String name, PropertySource<?> propertySource) {
        if (this.isAllowed(propertySource) && this.copy.getPropertySources().contains(name)) {
            PropertySource<?> original = this.getOriginal(propertySource);
            this.copy.getPropertySources().replace(name, original);
        }
    }

    public PropertySource<?> remove(String name) {
        return this.copy.getPropertySources().remove(name);
    }

    public ConfigurableEnvironment get() {
        return this.copy;
    }
}

