/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.view;

import com.mxgraph.layout.mxIGraphLayout;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxEvent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxUndoableEdit;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxGraph;
import java.awt.Point;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class mxLayoutManager
extends mxEventSource {
    protected mxGraph graph;
    protected boolean enabled = true;
    protected boolean bubbling = true;
    protected mxEventSource.mxIEventListener undoHandler = new mxEventSource.mxIEventListener(){

        @Override
        public void invoke(Object source, mxEventObject evt) {
            if (mxLayoutManager.this.isEnabled()) {
                mxLayoutManager.this.beforeUndo((mxUndoableEdit)evt.getProperty("edit"));
            }
        }
    };
    protected mxEventSource.mxIEventListener moveHandler = new mxEventSource.mxIEventListener(){

        @Override
        public void invoke(Object source, mxEventObject evt) {
            if (mxLayoutManager.this.isEnabled()) {
                mxLayoutManager.this.cellsMoved((Object[])evt.getProperty("cells"), (Point)evt.getProperty("location"));
            }
        }
    };

    public mxLayoutManager(mxGraph graph) {
        this.setGraph(graph);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public boolean isBubbling() {
        return this.bubbling;
    }

    public void setBubbling(boolean value) {
        this.bubbling = value;
    }

    public mxGraph getGraph() {
        return this.graph;
    }

    public void setGraph(mxGraph value) {
        mxIGraphModel model;
        if (this.graph != null) {
            model = this.graph.getModel();
            model.removeListener(this.undoHandler);
            this.graph.removeListener(this.moveHandler);
        }
        this.graph = value;
        if (this.graph != null) {
            model = this.graph.getModel();
            model.addListener("beforeUndo", this.undoHandler);
            this.graph.addListener("moveCells", this.moveHandler);
        }
    }

    protected mxIGraphLayout getLayout(Object parent) {
        return null;
    }

    protected void cellsMoved(Object[] cells, Point location) {
        if (cells != null && location != null) {
            mxIGraphModel model = this.getGraph().getModel();
            for (int i = 0; i < cells.length; ++i) {
                mxIGraphLayout layout = this.getLayout(model.getParent(cells[i]));
                if (layout == null) continue;
                layout.moveCell(cells[i], location.x, location.y);
            }
        }
    }

    protected void beforeUndo(mxUndoableEdit edit) {
        Collection<Object> cells = this.getCellsForChanges(edit.getChanges());
        mxIGraphModel model = this.getGraph().getModel();
        if (this.isBubbling()) {
            Object[] tmp = mxGraphModel.getParents(model, cells.toArray());
            while (tmp.length > 0) {
                cells.addAll(Arrays.asList(tmp));
                tmp = mxGraphModel.getParents(model, tmp);
            }
        }
        this.layoutCells(mxUtils.sortCells(cells, false).toArray());
    }

    protected Collection<Object> getCellsForChanges(List<mxUndoableEdit.mxUndoableChange> changes) {
        HashSet<Object> result = new HashSet<Object>();
        for (mxUndoableEdit.mxUndoableChange change : changes) {
            if (change instanceof mxGraphModel.mxRootChange) {
                return new HashSet<Object>();
            }
            result.addAll(this.getCellsForChange(change));
        }
        return result;
    }

    protected Collection<Object> getCellsForChange(mxUndoableEdit.mxUndoableChange change) {
        mxIGraphModel model = this.getGraph().getModel();
        HashSet<Object> result = new HashSet<Object>();
        if (change instanceof mxGraphModel.mxChildChange) {
            mxGraphModel.mxChildChange cc = (mxGraphModel.mxChildChange)change;
            Object parent = model.getParent(cc.getChild());
            if (cc.getChild() != null) {
                result.add(cc.getChild());
            }
            if (parent != null) {
                result.add(parent);
            }
            if (cc.getPrevious() != null) {
                result.add(cc.getPrevious());
            }
        } else if (change instanceof mxGraphModel.mxTerminalChange || change instanceof mxGraphModel.mxGeometryChange) {
            Object cell;
            Object object = cell = change instanceof mxGraphModel.mxTerminalChange ? ((mxGraphModel.mxTerminalChange)change).getCell() : ((mxGraphModel.mxGeometryChange)change).getCell();
            if (cell != null) {
                result.add(cell);
                Object parent = model.getParent(cell);
                if (parent != null) {
                    result.add(parent);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void layoutCells(Object[] cells) {
        if (cells.length > 0) {
            mxIGraphModel model = this.getGraph().getModel();
            model.beginUpdate();
            try {
                for (int i = 0; i < cells.length; ++i) {
                    if (cells[i] == model.getRoot()) continue;
                    this.executeLayout(this.getLayout(cells[i]), cells[i]);
                }
                this.fireEvent(new mxEventObject(mxEvent.LAYOUT_CELLS, "cells", cells));
            }
            finally {
                model.endUpdate();
            }
        }
    }

    protected void executeLayout(mxIGraphLayout layout, Object parent) {
        if (layout != null && parent != null) {
            layout.execute(parent);
        }
    }

    public void destroy() {
        this.setGraph(null);
    }
}

