/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.cipher;

import com.wechat.pay.java.core.cipher.PrivacyDecryptor;
import com.wechat.pay.java.core.exception.DecryptionException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.Base64;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public abstract class AbstractPrivacyDecryptor
implements PrivacyDecryptor {
    private final PrivateKey privateKey;
    private final Cipher cipher;

    protected AbstractPrivacyDecryptor(String transformation, PrivateKey privateKey) {
        this.privateKey = Objects.requireNonNull(privateKey);
        try {
            this.cipher = Cipher.getInstance(transformation);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalArgumentException("The current Java environment does not support " + transformation, e);
        }
    }

    @Override
    public String decrypt(String ciphertext) {
        Objects.requireNonNull(ciphertext);
        try {
            this.cipher.init(2, this.privateKey);
            return new String(this.cipher.doFinal(Base64.getDecoder().decode(ciphertext)), StandardCharsets.UTF_8);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("The given private key is invalid for decryption", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new DecryptionException("Decryption failed", e);
        }
    }
}

