/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.cipher;

import com.wechat.pay.java.core.cipher.PrivacyEncryptor;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.Base64;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public abstract class AbstractPrivacyEncryptor
implements PrivacyEncryptor {
    private final PublicKey publicKey;
    private final Cipher cipher;
    private final String wechatPaySerial;

    protected AbstractPrivacyEncryptor(String transformation, PublicKey publicKey, String wechatPaySerial) {
        this.publicKey = Objects.requireNonNull(publicKey);
        this.wechatPaySerial = Objects.requireNonNull(wechatPaySerial).toUpperCase();
        try {
            this.cipher = Cipher.getInstance(transformation);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalArgumentException("The current Java environment does not support " + transformation, e);
        }
    }

    @Override
    public String encrypt(String plaintext) {
        Objects.requireNonNull(plaintext);
        try {
            this.cipher.init(1, this.publicKey);
            return Base64.getEncoder().encodeToString(this.cipher.doFinal(plaintext.getBytes(StandardCharsets.UTF_8)));
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("RSA encryption using an illegal publicKey", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalArgumentException("Plaintext is too long", e);
        }
    }

    @Override
    public String getWechatpaySerial() {
        return this.wechatPaySerial;
    }
}

