/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public class ShaUtil {
    public static final int BUFFER_SIZE = 1024;
    public static final String SHA1 = "SHA-1";
    public static final String SHA256 = "SHA-256";

    private ShaUtil() {
    }

    public static String getSha1HexString(InputStream inputStream) throws IOException {
        try {
            return ShaUtil.getShaHexString(inputStream, SHA1);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSha256HexString(InputStream inputStream) throws IOException {
        try {
            return ShaUtil.getShaHexString(inputStream, SHA256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSha256HexString(byte[] source) {
        try {
            return ShaUtil.getShaHexString(source, SHA256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getShaHexString(InputStream inputStream, String algorithm) throws NoSuchAlgorithmException, IOException {
        int nRead;
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        byte[] data = new byte[1024];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            digest.update(data, 0, nRead);
        }
        return ShaUtil.toHexString(digest.digest());
    }

    private static String getShaHexString(byte[] source, String algorithm) throws NoSuchAlgorithmException {
        Objects.requireNonNull(source);
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        digest.update(source);
        return ShaUtil.toHexString(digest.digest());
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

