/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.lovefeast;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.http.UrlEncoder;
import com.wechat.pay.java.core.util.GsonUtil;
import com.wechat.pay.java.service.lovefeast.model.BrandEntity;
import com.wechat.pay.java.service.lovefeast.model.GetBrandRequest;
import com.wechat.pay.java.service.lovefeast.model.GetByUserRequest;
import com.wechat.pay.java.service.lovefeast.model.ListByUserRequest;
import com.wechat.pay.java.service.lovefeast.model.OrdersEntity;
import com.wechat.pay.java.service.lovefeast.model.OrdersListByUserResponse;
import java.util.Objects;

public class LovefeastService {
    private final HttpClient httpClient;
    private final HostName hostName;

    private LovefeastService(HttpClient httpClient, HostName hostName) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.hostName = hostName;
    }

    public BrandEntity getBrand(GetBrandRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/lovefeast/brands/{brand_id}";
        GetBrandRequest realRequest = request;
        requestPath = requestPath.replace("{brand_id}", UrlEncoder.urlEncode((String)realRequest.getBrandId().toString()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, BrandEntity.class);
        return (BrandEntity)httpResponse.getServiceResponse();
    }

    public OrdersEntity getByUser(GetByUserRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/lovefeast/users/{openid}/orders/out-trade-no/{out_trade_no}";
        GetByUserRequest realRequest = request;
        requestPath = requestPath.replace("{openid}", UrlEncoder.urlEncode((String)realRequest.getOpenid()));
        requestPath = requestPath.replace("{out_trade_no}", UrlEncoder.urlEncode((String)realRequest.getOutTradeNo()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, OrdersEntity.class);
        return (OrdersEntity)httpResponse.getServiceResponse();
    }

    public OrdersListByUserResponse listByUser(ListByUserRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/lovefeast/users/{openid}/orders/brand-id/{brand_id}";
        ListByUserRequest realRequest = request;
        requestPath = requestPath.replace("{openid}", UrlEncoder.urlEncode((String)realRequest.getOpenid()));
        requestPath = requestPath.replace("{brand_id}", UrlEncoder.urlEncode((String)realRequest.getBrandId().toString()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getLimit() != null) {
            queryParameter.add("limit", (Object)UrlEncoder.urlEncode((String)realRequest.getLimit().toString()));
        }
        if (realRequest.getOffset() != null) {
            queryParameter.add("offset", (Object)UrlEncoder.urlEncode((String)realRequest.getOffset().toString()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, OrdersListByUserResponse.class);
        return (OrdersListByUserResponse)httpResponse.getServiceResponse();
    }

    private RequestBody createRequestBody(Object request) {
        return new JsonRequestBody.Builder().body(GsonUtil.toJson((Object)request)).build();
    }

    public static class Builder {
        private HttpClient httpClient;
        private HostName hostName;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().credential(Objects.requireNonNull(config.createCredential())).validator(Objects.requireNonNull(config.createValidator())).build();
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public LovefeastService build() {
            return new LovefeastService(this.httpClient, this.hostName);
        }
    }
}

