/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.transferbatch;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.cipher.PrivacyDecryptor;
import com.wechat.pay.java.core.cipher.PrivacyEncryptor;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.http.UrlEncoder;
import com.wechat.pay.java.core.util.GsonUtil;
import com.wechat.pay.java.service.transferbatch.model.GetTransferBatchByNoRequest;
import com.wechat.pay.java.service.transferbatch.model.GetTransferBatchByOutNoRequest;
import com.wechat.pay.java.service.transferbatch.model.GetTransferDetailByNoRequest;
import com.wechat.pay.java.service.transferbatch.model.GetTransferDetailByOutNoRequest;
import com.wechat.pay.java.service.transferbatch.model.InitiateBatchTransferRequest;
import com.wechat.pay.java.service.transferbatch.model.InitiateBatchTransferResponse;
import com.wechat.pay.java.service.transferbatch.model.TransferBatchEntity;
import com.wechat.pay.java.service.transferbatch.model.TransferDetailEntity;
import java.util.Objects;

public class TransferBatchService {
    private final HttpClient httpClient;
    private final HostName hostName;
    private final PrivacyEncryptor encryptor;
    private final PrivacyDecryptor decryptor;

    private TransferBatchService(HttpClient httpClient, HostName hostName, PrivacyEncryptor encryptor, PrivacyDecryptor decryptor) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.hostName = hostName;
        this.encryptor = Objects.requireNonNull(encryptor);
        this.decryptor = Objects.requireNonNull(decryptor);
    }

    public TransferBatchEntity getTransferBatchByNo(GetTransferBatchByNoRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/transfer/batches/batch-id/{batch_id}";
        GetTransferBatchByNoRequest realRequest = request;
        requestPath = requestPath.replace("{batch_id}", UrlEncoder.urlEncode((String)realRequest.getBatchId()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getNeedQueryDetail() != null) {
            queryParameter.add("need_query_detail", (Object)UrlEncoder.urlEncode((String)realRequest.getNeedQueryDetail().toString()));
        }
        if (realRequest.getOffset() != null) {
            queryParameter.add("offset", (Object)UrlEncoder.urlEncode((String)realRequest.getOffset().toString()));
        }
        if (realRequest.getLimit() != null) {
            queryParameter.add("limit", (Object)UrlEncoder.urlEncode((String)realRequest.getLimit().toString()));
        }
        if (realRequest.getDetailStatus() != null) {
            queryParameter.add("detail_status", (Object)UrlEncoder.urlEncode((String)realRequest.getDetailStatus()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, TransferBatchEntity.class);
        return (TransferBatchEntity)httpResponse.getServiceResponse();
    }

    public TransferBatchEntity getTransferBatchByOutNo(GetTransferBatchByOutNoRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/transfer/batches/out-batch-no/{out_batch_no}";
        GetTransferBatchByOutNoRequest realRequest = request;
        requestPath = requestPath.replace("{out_batch_no}", UrlEncoder.urlEncode((String)realRequest.getOutBatchNo()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getNeedQueryDetail() != null) {
            queryParameter.add("need_query_detail", (Object)UrlEncoder.urlEncode((String)realRequest.getNeedQueryDetail().toString()));
        }
        if (realRequest.getOffset() != null) {
            queryParameter.add("offset", (Object)UrlEncoder.urlEncode((String)realRequest.getOffset().toString()));
        }
        if (realRequest.getLimit() != null) {
            queryParameter.add("limit", (Object)UrlEncoder.urlEncode((String)realRequest.getLimit().toString()));
        }
        if (realRequest.getDetailStatus() != null) {
            queryParameter.add("detail_status", (Object)UrlEncoder.urlEncode((String)realRequest.getDetailStatus()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, TransferBatchEntity.class);
        return (TransferBatchEntity)httpResponse.getServiceResponse();
    }

    public InitiateBatchTransferResponse initiateBatchTransfer(InitiateBatchTransferRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/transfer/batches";
        InitiateBatchTransferRequest realRequest = request.cloneWithCipher(arg_0 -> ((PrivacyEncryptor)this.encryptor).encrypt(arg_0));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Wechatpay-Serial", this.encryptor.getWechatpaySerial());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, InitiateBatchTransferResponse.class);
        return (InitiateBatchTransferResponse)httpResponse.getServiceResponse();
    }

    public TransferDetailEntity getTransferDetailByNo(GetTransferDetailByNoRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/transfer/batches/batch-id/{batch_id}/details/detail-id/{detail_id}";
        GetTransferDetailByNoRequest realRequest = request;
        requestPath = requestPath.replace("{batch_id}", UrlEncoder.urlEncode((String)realRequest.getBatchId()));
        requestPath = requestPath.replace("{detail_id}", UrlEncoder.urlEncode((String)realRequest.getDetailId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, TransferDetailEntity.class);
        return ((TransferDetailEntity)httpResponse.getServiceResponse()).cloneWithCipher(arg_0 -> ((PrivacyDecryptor)this.decryptor).decrypt(arg_0));
    }

    public TransferDetailEntity getTransferDetailByOutNo(GetTransferDetailByOutNoRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/transfer/batches/out-batch-no/{out_batch_no}/details/out-detail-no/{out_detail_no}";
        GetTransferDetailByOutNoRequest realRequest = request;
        requestPath = requestPath.replace("{out_detail_no}", UrlEncoder.urlEncode((String)realRequest.getOutDetailNo()));
        requestPath = requestPath.replace("{out_batch_no}", UrlEncoder.urlEncode((String)realRequest.getOutBatchNo()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, TransferDetailEntity.class);
        return ((TransferDetailEntity)httpResponse.getServiceResponse()).cloneWithCipher(arg_0 -> ((PrivacyDecryptor)this.decryptor).decrypt(arg_0));
    }

    private RequestBody createRequestBody(Object request) {
        return new JsonRequestBody.Builder().body(GsonUtil.toJson((Object)request)).build();
    }

    public static class Builder {
        private HttpClient httpClient;
        private HostName hostName;
        private PrivacyEncryptor encryptor;
        private PrivacyDecryptor decryptor;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().credential(Objects.requireNonNull(config.createCredential())).validator(Objects.requireNonNull(config.createValidator())).build();
            this.encryptor = config.createEncryptor();
            this.decryptor = config.createDecryptor();
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder encryptor(PrivacyEncryptor encryptor) {
            this.encryptor = encryptor;
            return this;
        }

        public Builder decryptor(PrivacyDecryptor decryptor) {
            this.decryptor = decryptor;
            return this;
        }

        public TransferBatchService build() {
            return new TransferBatchService(this.httpClient, this.hostName, this.encryptor, this.decryptor);
        }
    }
}

