/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.graphics;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.Map;

public class GraphicsContext {
    private final Graphics2D graphics2D;
    private Composite composite;
    private Map<?, ?> hintsMap;
    private Stroke stroke;
    private Color color;
    private Paint paint;
    private Font font;
    private Shape clip;
    private AffineTransform transform;

    public GraphicsContext(Graphics g) {
        this.graphics2D = (Graphics2D)g;
        this.save();
    }

    public Graphics2D getGraphics() {
        return this.graphics2D;
    }

    public void restore() {
        this.restoreRenderingHints();
        this.restoreComposite();
        this.restoreStroke();
        this.restoreColor();
        this.restorePaint();
        this.restoreFont();
        this.restoreClip();
        this.restoreTransform();
    }

    public void save() {
        this.saveRenderingHints();
        this.saveComposite();
        this.saveStroke();
        this.saveColor();
        this.savePaint();
        this.saveFont();
        this.saveClip();
        this.saveTransform();
    }

    public void restoreTransform() {
        this.graphics2D.setTransform(this.transform);
    }

    public void restoreComposite() {
        this.graphics2D.setComposite(this.composite);
    }

    public void restoreFont() {
        this.graphics2D.setFont(this.font);
    }

    public void restoreRenderingHints() {
        this.graphics2D.setRenderingHints(this.hintsMap);
    }

    public void restoreStroke() {
        this.graphics2D.setStroke(this.stroke);
    }

    public void restoreColor() {
        this.graphics2D.setColor(this.color);
    }

    public void restorePaint() {
        this.graphics2D.setPaint(this.paint);
    }

    public void restoreClip() {
        this.graphics2D.setClip(this.clip);
    }

    public void saveTransform() {
        this.transform = this.graphics2D.getTransform();
    }

    public void saveComposite() {
        this.composite = this.graphics2D.getComposite();
    }

    public void saveFont() {
        this.font = this.graphics2D.getFont();
    }

    public void saveRenderingHints() {
        this.hintsMap = this.graphics2D.getRenderingHints();
    }

    public void saveStroke() {
        this.stroke = this.graphics2D.getStroke();
    }

    public void saveColor() {
        this.color = this.graphics2D.getColor();
    }

    public void savePaint() {
        this.paint = this.graphics2D.getPaint();
    }

    public void saveClip() {
        this.clip = this.graphics2D.getClip();
    }
}

