/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.task;

import com.github.weisj.darklaf.color.DarkColorModelHSB;
import com.github.weisj.darklaf.task.ColorAdjustmentTask;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.uiresource.DarkColorUIResource;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.Pair;
import java.awt.Color;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class AccentColorAdjustmentTask
extends ColorAdjustmentTask {
    private static final Logger LOGGER = LogUtil.getLogger(AccentColorAdjustmentTask.class);
    private static final String MAIN_ACCENT_LIST_KEY = "accent.propertyList";
    private static final String SELECTION_ACCENT_LIST_KEY = "selection.propertyList";

    @Override
    protected void runTask(Theme currentTheme, Properties properties) {
        Color accentColor = currentTheme.getAccentColorRule().getAccentColor();
        Color selectionColor = currentTheme.getAccentColorRule().getSelectionColor();
        this.applyColors(currentTheme, properties, accentColor, selectionColor);
    }

    public void applyColors(Theme currentTheme, Properties properties, Color accentColor, Color selectionColor) {
        if (!currentTheme.supportsCustomAccentColor() && !currentTheme.supportsCustomSelectionColor()) {
            return;
        }
        if (accentColor == null && selectionColor == null) {
            return;
        }
        Properties props = currentTheme.loadAccentProperties();
        if (props == null || props.isEmpty()) {
            return;
        }
        if (accentColor != null) {
            this.adjustColors(MAIN_ACCENT_LIST_KEY, accentColor, props, properties);
        }
        if (selectionColor != null) {
            this.adjustColors(SELECTION_ACCENT_LIST_KEY, selectionColor, props, properties);
        }
    }

    private void adjustColors(String listKey, Color c, Properties listProperties, Properties properties) {
        this.adjust(listKey, listProperties, list -> {
            double[] hsb = DarkColorModelHSB.RGBtoHSBValues(c.getRed(), c.getGreen(), c.getBlue());
            this.adjustColorList((List<?>)list, hsb, properties);
        });
    }

    private void adjustColorList(List<?> list, double[] hsb, Properties properties) {
        ColorInfo info = new ColorInfo();
        for (Object o : list) {
            this.setColorInfo(o, info);
            if (info.key == null) continue;
            Object c = this.mapColor(info, hsb, properties);
            if (c instanceof Color) {
                properties.put(info.key, c);
                continue;
            }
            LOGGER.warning("Color with key '" + info.key + "' could not be adjusted because the value '" + c + ", '" + c.getClass() + " is not a color");
        }
    }

    private void setColorInfo(Object o, ColorInfo info) {
        info.set(null, 0, 0, 0);
        if (o instanceof String) {
            info.set(o.toString(), 100, 100, 100);
            return;
        }
        if (o instanceof Pair) {
            Object first = ((Pair)o).getFirst();
            Object second = ((Pair)o).getSecond();
            if (!(first instanceof String)) {
                return;
            }
            if (!(second instanceof List)) {
                return;
            }
            String key = first.toString();
            List list = (List)second;
            if (!(list.size() == 3 && list.get(0) instanceof Integer && list.get(1) instanceof Integer && list.get(2) instanceof Integer)) {
                return;
            }
            info.set(key, (Integer)list.get(0), (Integer)list.get(1), (Integer)list.get(2));
        }
    }

    private Object mapColor(ColorInfo info, double[] hsbMatch, Properties properties) {
        Object obj = properties.get(info.key);
        if (obj instanceof Color) {
            Color color = DarkColorModelHSB.getColorFromHSBValues(this.mapValue(hsbMatch[0], info.hAdj), this.mapValue(hsbMatch[1], info.sAdj), this.mapValue(hsbMatch[2], info.bAdj));
            return new DarkColorUIResource(color);
        }
        return obj;
    }

    private double mapValue(double value, int adjustment) {
        return value * ((double)adjustment / 100.0);
    }

    private static class ColorInfo {
        private String key;
        private int hAdj;
        private int sAdj;
        private int bAdj;

        private ColorInfo() {
        }

        private void set(String key, int hAdj, int sAdj, int bAdj) {
            this.key = key;
            this.hAdj = hAdj;
            this.sAdj = sAdj;
            this.bAdj = bAdj;
        }
    }
}

