/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui;

import com.github.weisj.darklaf.platform.DecorationsHandler;
import com.github.weisj.darklaf.uiresource.DarkColorUIResource;
import com.github.weisj.darklaf.util.ColorUtil;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.Pair;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DarkPopupFactory
extends PopupFactory {
    public static final String KEY_NO_DECORATION = "JPopupFactory.noDecorations";
    public static final String KEY_FOCUSABLE_POPUP = "JPopupFactory.focusablePopup";
    public static final String KEY_FORCE_HEAVYWEIGHT = "JPopupFactory.forceHeavyweight";
    public static final String KEY_OPAQUE = "JPopupFactory.opaque";
    public static final String KEY_START_HIDDEN = "JPopupFactory.startHidden";
    private HeavyWeightParent heavyWeightParent;

    @Override
    public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
        Pair<Popup, PopupType> result = this.getEffectivePopup(owner, contents, x, y);
        Popup popup = (Popup)result.getFirst();
        PopupType type = (PopupType)((Object)result.getSecond());
        this.setupPopup(type, contents, x, y);
        return popup;
    }

    protected Pair<Popup, PopupType> getEffectivePopup(Component owner, Component contents, int x, int y) {
        boolean forceHeavy;
        Popup popup = super.getPopup(owner, contents, x, y);
        PopupType type = DarkPopupFactory.getPopupType(popup);
        boolean bl = forceHeavy = type != PopupType.HEAVY_WEIGHT && PropertyUtil.getBooleanProperty((Component)contents, (String)KEY_FORCE_HEAVYWEIGHT);
        if (forceHeavy) {
            Window targetWindow = DarkUIUtil.getWindow(owner);
            popup = super.getPopup(this.getHeavyWeightParent(targetWindow), contents, x, y);
            type = PopupType.HEAVY_WEIGHT;
        }
        if (type == PopupType.HEAVY_WEIGHT) {
            Window window = DarkUIUtil.getWindow(contents);
            if (owner != null && window != null && !Objects.equals(window.getGraphicsConfiguration(), owner.getGraphicsConfiguration())) {
                window.setFocusableWindowState(true);
                popup = super.getPopup(this.getHeavyWeightParent(DarkUIUtil.getWindow(owner)), contents, x, y);
                window = DarkUIUtil.getWindow(contents);
            }
            if (window != null) {
                Window w = window;
                w.setLocation(x, y);
                SwingUtilities.invokeLater(() -> w.setLocation(x, y));
            }
        }
        return new Pair((Object)popup, (Object)type);
    }

    public static PopupType getPopupType(Popup popup) {
        String popupClassName = popup.getClass().getSimpleName();
        if (popupClassName.endsWith("LightWeightPopup")) {
            return PopupType.LIGHT_WEIGHT;
        }
        if (popupClassName.endsWith("MediumWeightPopup")) {
            return PopupType.MEDIUM_WEIGHT;
        }
        return PopupType.HEAVY_WEIGHT;
    }

    protected void setupPopup(PopupType type, Component contents, int x, int y) {
        Window window;
        if (type == PopupType.MEDIUM_WEIGHT) {
            JRootPane rootPane = SwingUtilities.getRootPane(contents);
            if (rootPane != null) {
                rootPane.putClientProperty("JRootPane.noDecorationsUpdate", true);
            }
        } else if (type == PopupType.HEAVY_WEIGHT && (window = SwingUtilities.getWindowAncestor(contents)) != null) {
            boolean isFocusable = PropertyUtil.getBooleanProperty((Component)contents, (String)KEY_FOCUSABLE_POPUP);
            boolean startHidden = PropertyUtil.getBooleanProperty((Component)contents, (String)KEY_START_HIDDEN);
            this.setupWindow(window, contents, isFocusable, startHidden);
            window.setLocation(x, y);
        }
    }

    protected void setupWindow(Window window, Component contents, boolean isFocusable, boolean startHidden) {
        boolean noDecorations = PropertyUtil.getBooleanProperty((Component)contents, (String)KEY_NO_DECORATION);
        boolean opaque = PropertyUtil.getBooleanProperty((Component)contents, (String)KEY_OPAQUE);
        JRootPane rootPane = window instanceof RootPaneContainer ? ((RootPaneContainer)((Object)window)).getRootPane() : null;
        this.setupWindowBackground(window, rootPane, opaque, !noDecorations);
        this.setupWindowFocusableState(isFocusable, window);
        this.setupWindowDecorations(window, rootPane, noDecorations);
        this.setupWindowOpacity(startHidden, window);
    }

    protected void setupWindowBackground(Window window, JRootPane rootPane, boolean opaque, boolean decorations) {
        if (rootPane == null) {
            return;
        }
        rootPane.setOpaque(opaque);
        if (opaque) {
            Color bg = ColorUtil.toAlpha((Color)rootPane.getBackground(), (int)255);
            window.setBackground(bg);
        } else {
            Color bg = this.getTranslucentPopupBackground(decorations);
            window.setBackground(bg);
            rootPane.setBackground(bg);
        }
    }

    protected void setupWindowFocusableState(boolean isFocusable, Window window) {
        if (isFocusable && !window.getFocusableWindowState()) {
            window.dispose();
            window.setFocusableWindowState(true);
        }
    }

    protected void setupWindowDecorations(Window window, JRootPane rootPane, boolean noDecorations) {
        if (rootPane != null) {
            rootPane.putClientProperty("Window.shadow", !noDecorations);
        }
        if (noDecorations) {
            DecorationsHandler.getSharedInstance().uninstallPopupWindow(window);
        } else if (DecorationsHandler.getSharedInstance().isCustomDecorationSupported()) {
            DecorationsHandler.getSharedInstance().installPopupWindow(window);
        }
    }

    protected void setupWindowOpacity(boolean startHidden, Window window) {
        boolean translucencySupported = DarkUIUtil.supportsTransparency(window);
        if (startHidden && translucencySupported) {
            try {
                window.setOpacity(0.0f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected HeavyWeightParent getHeavyWeightParent(Container owner) {
        if (this.heavyWeightParent == null) {
            Box box = Box.createHorizontalBox();
            super.getPopup(null, box, 0, 0);
            this.heavyWeightParent = new HeavyWeightParent(DarkUIUtil.getWindow(box));
        }
        this.heavyWeightParent.setOwner(owner);
        return this.heavyWeightParent;
    }

    protected Color getTranslucentPopupBackground(boolean decorated) {
        Color c = UIManager.getColor("PopupMenu.translucentBackground");
        if (!decorated) {
            c = new DarkColorUIResource(ColorUtil.toAlpha((Color)c, (int)0));
        }
        return c;
    }

    public static enum PopupType {
        LIGHT_WEIGHT,
        MEDIUM_WEIGHT,
        HEAVY_WEIGHT;

    }

    private static class HeavyWeightParent
    extends JComponent {
        private int parentRequestCount = 0;
        private final Window heavyWeightParent;
        private Container owner;

        private HeavyWeightParent(Window heavyWeightParent) {
            this.heavyWeightParent = heavyWeightParent;
        }

        public void setOwner(Container owner) {
            this.parentRequestCount = 0;
            this.owner = owner;
        }

        @Override
        public GraphicsConfiguration getGraphicsConfiguration() {
            return super.getGraphicsConfiguration();
        }

        @Override
        public Container getParent() {
            if (this.parentRequestCount == 0) {
                ++this.parentRequestCount;
                return this.heavyWeightParent;
            }
            return this.owner;
        }
    }
}

