/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.menu;

import com.github.weisj.darklaf.graphics.GraphicsContext;
import com.github.weisj.darklaf.graphics.GraphicsUtil;
import com.github.weisj.darklaf.listener.MouseInputDelegate;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class DarkMenuUI
extends BasicMenuUI {
    protected Icon arrowIconHover;
    protected JMenu menu;
    protected MouseListener mouseListener;

    public static ComponentUI createUI(JComponent x) {
        return new DarkMenuUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.menu = (JMenu)c;
        super.installUI(c);
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputDelegate(super.createMouseInputListener(c)){
            private boolean pressed;
            private boolean wasEnabled;
            {
                this.pressed = false;
                this.wasEnabled = false;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MenuElement[] selectedPath;
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                for (MenuElement element : selectedPath = manager.getSelectedPath()) {
                    if (!element.equals(DarkMenuUI.this.menu)) continue;
                    return;
                }
                super.mouseEntered(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.pressed = true;
                this.wasEnabled = DarkMenuUI.this.menu.isEnabled() && DarkMenuUI.this.menu.isSelected() && DarkMenuUI.this.menu.getPopupMenu().isShowing();
                super.mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!DarkMenuUI.this.menu.isEnabled()) {
                    return;
                }
                if (this.pressed && this.wasEnabled) {
                    this.pressed = false;
                    return;
                }
                super.mouseReleased(e);
            }
        };
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menu.removeMouseListener(this.mouseListener);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.acceleratorFont = UIManager.getFont("Menu.font");
        this.acceleratorForeground = UIManager.getColor("Menu.foreground");
        this.acceleratorSelectionForeground = UIManager.getColor("Menu.selectionForeground");
        this.arrowIconHover = UIManager.getIcon("Menu.arrowHover.icon");
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        GraphicsContext config = GraphicsUtil.setupAntialiasing(g);
        this.paintMenuItem(g, c, this.checkIcon, this.getArrowIcon(), this.selectionBackground, this.isSelected(c) ? this.selectionForeground : c.getForeground(), this.defaultTextIconGap);
        config.restore();
    }

    protected Icon getArrowIcon() {
        boolean hover = this.menuItem.getModel().isArmed() || this.menuItem instanceof JMenu && this.menuItem.getModel().isSelected();
        return hover ? this.arrowIconHover : this.arrowIcon;
    }

    protected boolean isSelected(JComponent menuItem) {
        if (!(menuItem instanceof JMenuItem)) {
            return false;
        }
        return menuItem.isEnabled() && ((JMenuItem)menuItem).isArmed();
    }
}

