/*
 * Decompiled with CFR 0.152.
 */
package org.pbjar.jxlayer.plaf.ext.transform;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.pbjar.jxlayer.plaf.ext.TransformUI;
import org.pbjar.jxlayer.plaf.ext.transform.DefaultLayerLayout;

public class TransformLayout
extends DefaultLayerLayout {
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.transform(parent, super.preferredLayoutSize(parent));
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.transform(parent, super.minimumLayoutSize(parent));
    }

    @Override
    public void layoutContainer(Container parent) {
        JXLayer layer = (JXLayer)parent;
        LayerUI layerUI = layer.getUI();
        if (layerUI instanceof TransformUI) {
            JComponent view = (JComponent)layer.getView();
            JPanel glassPane = layer.getGlassPane();
            if (view != null) {
                Rectangle innerArea = new Rectangle();
                SwingUtilities.calculateInnerArea((JComponent)layer, innerArea);
                view.setSize(view.getPreferredSize());
                Rectangle viewRect = new Rectangle(0, 0, view.getWidth(), view.getHeight());
                int x = (int)Math.round(innerArea.getCenterX() - viewRect.getCenterX());
                int y = (int)Math.round(innerArea.getCenterY() - viewRect.getCenterY());
                viewRect.translate(x, y);
                view.setBounds(viewRect);
            }
            if (glassPane != null) {
                glassPane.setLocation(0, 0);
                glassPane.setSize(layer.getWidth(), layer.getHeight());
            }
            return;
        }
        super.layoutContainer(parent);
    }

    private Dimension transform(Container parent, Dimension size) {
        TransformUI transformUI;
        AffineTransform transform;
        JXLayer layer = (JXLayer)parent;
        LayerUI ui = layer.getUI();
        if (ui instanceof TransformUI && (transform = (transformUI = (TransformUI)ui).getPreferredTransform(size, (JXLayer<? extends JComponent>)layer)) != null) {
            Area area = new Area(new Rectangle2D.Double(0.0, 0.0, size.getWidth(), size.getHeight()));
            area.transform(transform);
            Rectangle2D bounds = area.getBounds2D();
            size.setSize(bounds.getWidth(), bounds.getHeight());
        }
        return size;
    }
}

