/*
 * Decompiled with CFR 0.152.
 */
package com.ace.cache.aspect;

import com.ace.cache.annotation.Cache;
import com.ace.cache.api.CacheAPI;
import com.ace.cache.parser.ICacheResultParser;
import com.ace.cache.parser.IKeyGenerator;
import com.ace.cache.parser.impl.DefaultKeyGenerator;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Aspect
@Service
public class CacheAspect {
    @Autowired
    private IKeyGenerator keyParser;
    @Autowired
    private CacheAPI cacheAPI;
    protected Logger log = Logger.getLogger(this.getClass());
    private ConcurrentHashMap<String, ICacheResultParser> parserMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, IKeyGenerator> generatorMap = new ConcurrentHashMap();

    @Pointcut(value="@annotation(com.ace.cache.annotation.Cache)")
    public void aspect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="aspect()&&@annotation(anno)")
    public Object interceptor(ProceedingJoinPoint invocation, Cache anno) throws Throwable {
        MethodSignature signature = (MethodSignature)invocation.getSignature();
        Method method = signature.getMethod();
        Object result = null;
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] arguments = invocation.getArgs();
        String key = "";
        String value = "";
        try {
            key = this.getKey(anno, parameterTypes, arguments);
            value = this.cacheAPI.get(key);
            Type returnType = method.getGenericReturnType();
            result = this.getResult(anno, result, value, returnType);
        }
        catch (Exception e) {
            this.log.error((Object)("\u83b7\u53d6\u7f13\u5b58\u5931\u8d25\uff1a" + key), (Throwable)e);
        }
        finally {
            if (result == null) {
                result = invocation.proceed();
                if (StringUtils.isNotBlank((CharSequence)key)) {
                    this.cacheAPI.set(key, result, anno.expire());
                }
            }
        }
        return result;
    }

    private String getKey(Cache anno, Class<?>[] parameterTypes, Object[] arguments) throws InstantiationException, IllegalAccessException {
        String generatorClsName = anno.generator().getName();
        IKeyGenerator keyGenerator = null;
        if (anno.generator().equals(DefaultKeyGenerator.class)) {
            keyGenerator = this.keyParser;
        } else if (this.generatorMap.contains(generatorClsName)) {
            keyGenerator = this.generatorMap.get(generatorClsName);
        } else {
            keyGenerator = anno.generator().newInstance();
            this.generatorMap.put(generatorClsName, keyGenerator);
        }
        String key = keyGenerator.getKey(anno.key(), anno.scope(), parameterTypes, arguments);
        return key;
    }

    private Object getResult(Cache anno, Object result, String value, Type returnType) throws InstantiationException, IllegalAccessException {
        String parserClsName = anno.parser().getName();
        ICacheResultParser parser = null;
        if (this.parserMap.containsKey(parserClsName)) {
            parser = this.parserMap.get(parserClsName);
        } else {
            parser = anno.parser().newInstance();
            this.parserMap.put(parserClsName, parser);
        }
        if (parser != null) {
            result = anno.result()[0].equals(Object.class) ? parser.parse(value, returnType, null) : parser.parse(value, returnType, anno.result());
        }
        return result;
    }
}

