/*
 * Decompiled with CFR 0.152.
 */
package com.ace.cache.service.impl;

import com.ace.cache.api.CacheAPI;
import com.ace.cache.config.RedisConfig;
import com.ace.cache.entity.CacheBean;
import com.ace.cache.service.ICacheManager;
import com.ace.cache.vo.CacheTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class CacheManagerImpl
implements ICacheManager {
    @Autowired
    private Environment env;
    @Autowired
    private CacheAPI cacheAPI;
    @Autowired
    private RedisConfig redisConfig;

    @Override
    public void removeAll() {
        this.cacheAPI.removeByPre(this.redisConfig.getSysName());
    }

    @Override
    public void remove(String key) {
        this.cacheAPI.remove(key);
    }

    @Override
    public void remove(List<CacheBean> caches) {
        String[] keys = new String[caches.size()];
        int i = 0;
        for (CacheBean cache : caches) {
            keys[i] = cache.getKey();
            ++i;
        }
        this.cacheAPI.remove(keys);
    }

    @Override
    public void removeByPre(String pre) {
        if (!pre.contains(this.redisConfig.getSysName())) {
            pre = this.redisConfig.getSysName() + ":" + pre + "*";
        }
        this.cacheAPI.removeByPre(pre);
    }

    @Override
    public List<CacheTree> getAll() {
        List<CacheBean> caches = this.cacheAPI.listAll();
        List<CacheTree> cts = this.toTree(caches);
        return cts;
    }

    private List<CacheTree> toTree(List<CacheBean> caches) {
        ArrayList<CacheTree> result = new ArrayList<CacheTree>();
        HashSet<CacheTree> cts = new HashSet<CacheTree>();
        CacheTree ct = new CacheTree();
        for (CacheBean cache : caches) {
            String[] split = cache.getKey().split(":");
            for (int i = split.length - 1; i > 0; --i) {
                ct = i == split.length - 1 ? new CacheTree(cache) : new CacheTree();
                if (i - 1 >= 0) {
                    ct.setId(split[i]);
                    ct.setParentId(split[i - 1].endsWith(this.redisConfig.getSysName()) ? "-1" : split[i - 1]);
                }
                if (split.length == 2) {
                    cts.remove(ct);
                }
                cts.add(ct);
            }
        }
        result.addAll(cts);
        return result;
    }

    @Override
    public List<CacheTree> getByPre(String pre) {
        if (StringUtils.isBlank((CharSequence)pre)) {
            return this.getAll();
        }
        if (!pre.contains(this.redisConfig.getSysName())) {
            pre = this.redisConfig.getSysName() + "*" + pre;
        }
        return this.toTree(this.cacheAPI.getCacheBeanByPre(pre));
    }

    public CacheAPI getCacheAPI() {
        return this.cacheAPI;
    }

    public void setCacheAPI(CacheAPI cacheAPI) {
        this.cacheAPI = cacheAPI;
    }

    @Override
    public void update(String key, int hour) {
        String value = this.cacheAPI.get(key);
        this.cacheAPI.set(key, value, hour * 60);
    }

    @Override
    public void update(List<CacheBean> caches, int hour) {
        for (CacheBean cache : caches) {
            String value = this.cacheAPI.get(cache.getKey());
            this.cacheAPI.set(cache.getKey(), value, hour);
        }
    }

    @Override
    public String get(String key) {
        return this.cacheAPI.get(key);
    }
}

