/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.core.util;

import com.github.xiaoymin.knife4j.core.util.StrUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    static final String COMMON_REGEX = "[a-zA-Z0-9]";
    static final String COMMON_BEAN_NAME_PREFIX = "Knife4jDocket";
    static Logger logger = LoggerFactory.getLogger(CommonUtils.class);

    public static String getDebugUri(String source) {
        if (StrUtil.isNotBlank(source)) {
            String trimSource = source.trim();
            if (trimSource.startsWith("http://") || trimSource.startsWith("https://")) {
                return trimSource;
            }
            return "http://" + trimSource;
        }
        return "";
    }

    public static String getRandomBeanName(String source) {
        String beanName = "";
        if (source != null && !"".equals(source)) {
            try {
                String[] chars;
                String tmp = URLEncoder.encode(source, StandardCharsets.UTF_8.name());
                StringBuilder appender = new StringBuilder("");
                for (String charStr : chars = tmp.split("")) {
                    if (!charStr.matches(COMMON_REGEX)) continue;
                    appender.append(charStr);
                }
                beanName = appender.toString();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            beanName = UUID.randomUUID().toString();
        }
        return COMMON_BEAN_NAME_PREFIX + beanName;
    }

    public static String genSupperName(String name) {
        String supperName = "";
        if (name != null && !"".equals(name)) {
            supperName = name.length() == 1 ? name.toUpperCase() : name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return supperName;
    }

    public static String upperCase(String str) {
        StringBuffer aa = new StringBuffer();
        int index = 0;
        int index22 = 0;
        int len = str.length();
        for (int i = 1; i < len; ++i) {
            if (Character.isUpperCase(str.charAt(i))) {
                if (Character.isUpperCase(str.charAt(i + 1))) {
                    aa.append(str.substring(index, i)).append("");
                } else {
                    aa.append(str.substring(index, i)).append(" ");
                }
                index = i;
                ++index22;
                continue;
            }
            index22 = 0;
        }
        aa.append(str.substring(index, len));
        return aa.toString();
    }

    public static byte[] readBytes(File file) {
        long len = file.length();
        if (len >= Integer.MAX_VALUE) {
            throw new RuntimeException("File is larger then max array size");
        }
        byte[] bytes = new byte[(int)len];
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            int readLength = in.read(bytes);
            if ((long)readLength < len) {
                throw new IOException("File length is [" + len + "] but read [" + readLength + "]!");
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonUtils.close(in);
                throw throwable;
            }
        }
        CommonUtils.close(in);
        return bytes;
    }

    public static byte[] readBytes(InputStream ins) {
        if (ins == null) {
            return null;
        }
        ByteArrayOutputStream byteOutArr = new ByteArrayOutputStream();
        int r = -1;
        byte[] bytes = new byte[0x100000];
        try {
            while ((r = ins.read(bytes)) != -1) {
                byteOutArr.write(bytes, 0, r);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            CommonUtils.close(ins);
        }
        return byteOutArr.toByteArray();
    }

    public static String resolveMarkdownTitle(InputStream inputStream, String fileName) {
        String title = fileName;
        try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String le = null;
            String reg = "#{1,3}\\s{1}(.*)";
            Pattern pattern = Pattern.compile(reg, 2);
            Matcher matcher = null;
            while ((le = reader2.readLine()) != null) {
                matcher = pattern.matcher(le);
                if (!matcher.matches()) continue;
                title = matcher.group(1);
                break;
            }
        }
        catch (UnsupportedEncodingException reader2) {
        }
        catch (IOException e) {
            logger.warn("(Ignores) Failed to read Markdown files,Error Message:{} ", (Object)e.getMessage());
        }
        return title;
    }

    public static void close(InputStream ins) {
        if (ins != null) {
            try {
                ins.close();
            }
            catch (IOException e) {
                logger.warn("(Ignores) Failed to closeQuiltly,message:{}", (Object)e.getMessage());
            }
        }
    }

    public static void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                logger.warn("(Ignores) Failed to closeQuiltly,message:{}", (Object)e.getMessage());
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(CommonUtils.getRandomBeanName("\u6d4b\u8bd5\u4e00\u4e0b\u5427"));
        System.out.println(CommonUtils.getRandomBeanName("\u6d4b\u8bd5\u4e00\u4e0b\u5427-=13\u3010\u301113\u3010-1=31=-3=1313"));
        System.out.println(CommonUtils.getRandomBeanName("\u6d4b\u8bd5\u4e00\u4e0b\u5427\uff01@\uff01\uff09@\uff08\uff09\uff01*#**\uff09\uff01*#&\u2026\u2026\u2026\u2026%%"));
    }
}

