/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway.discover.router;

import com.github.xiaoymin.knife4j.spring.gateway.Knife4jGatewayProperties;
import com.github.xiaoymin.knife4j.spring.gateway.discover.ServiceRouterHolder;
import com.github.xiaoymin.knife4j.spring.gateway.discover.router.AbstactServiceRouterConvert;
import com.github.xiaoymin.knife4j.spring.gateway.enums.GatewayRouterStrategy;
import com.github.xiaoymin.knife4j.spring.gateway.utils.ServiceUtils;
import com.github.xiaoymin.knife4j.spring.gateway.utils.StrUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.config.GatewayProperties;

public class ConfigRouteServiceConvert
extends AbstactServiceRouterConvert {
    private static final Logger log = LoggerFactory.getLogger(ConfigRouteServiceConvert.class);
    final GatewayProperties gatewayProperties;
    final Knife4jGatewayProperties knife4jGatewayProperties;

    @Override
    public void process(ServiceRouterHolder routerHolder) {
        log.debug("Spring Cloud Gateway Routes Config process.");
        this.gatewayProperties.getRoutes().stream().filter(routeDefinition -> ServiceUtils.startLoadBalance(routeDefinition.getUri())).filter(routeDefinition -> ServiceUtils.includeService(routeDefinition.getUri(), routerHolder.getService(), routerHolder.getExcludeService())).forEach(routeDefinition -> this.parseRouteDefinition(routerHolder, routeDefinition.getPredicates(), routeDefinition.getUri().getHost(), routeDefinition.getUri().getHost()));
    }

    @Override
    String convertPathPrefix(Map<String, String> predicateArgs) {
        String value = predicateArgs.get(GatewayRouterStrategy.CONFIG.getRule());
        if (StrUtil.isNotBlank(value)) {
            return value.replace("**", "");
        }
        return "";
    }

    @Override
    public int order() {
        return GatewayRouterStrategy.CONFIG.getOrder();
    }

    @Override
    Knife4jGatewayProperties.Discover getDiscover() {
        return this.knife4jGatewayProperties.getDiscover();
    }

    public ConfigRouteServiceConvert(GatewayProperties gatewayProperties, Knife4jGatewayProperties knife4jGatewayProperties) {
        this.gatewayProperties = gatewayProperties;
        this.knife4jGatewayProperties = knife4jGatewayProperties;
    }
}

