/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.common.bean;

import com.github.xiaoymin.knife4j.core.util.CollectionUtils;
import com.github.xiaoymin.knife4j.core.util.StrUtil;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.context.MessageSource;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.Operation;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.swagger2.mappers.LicenseMapper;
import springfox.documentation.swagger2.mappers.ModelMapper;
import springfox.documentation.swagger2.mappers.ParameterMapper;
import springfox.documentation.swagger2.mappers.SecurityMapper;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;
import springfox.documentation.swagger2.mappers.VendorExtensionsMapper;

public class Knife4jI18nServiceModelToSwagger2MapperImpl
extends ServiceModelToSwagger2Mapper {
    final MessageSource messageSource;
    final Locale locale;
    final ModelMapper modelMapper;
    final ParameterMapper parameterMapper;
    final SecurityMapper securityMapper;
    final LicenseMapper licenseMapper;
    final VendorExtensionsMapper vendorExtensionsMapper;

    public Knife4jI18nServiceModelToSwagger2MapperImpl(MessageSource messageSource, Locale locale, ModelMapper modelMapper, ParameterMapper parameterMapper, SecurityMapper securityMapper, LicenseMapper licenseMapper, VendorExtensionsMapper vendorExtensionsMapper) {
        this.messageSource = messageSource;
        this.locale = locale;
        this.modelMapper = modelMapper;
        this.parameterMapper = parameterMapper;
        this.securityMapper = securityMapper;
        this.licenseMapper = licenseMapper;
        this.vendorExtensionsMapper = vendorExtensionsMapper;
    }

    public Swagger mapDocumentation(Documentation from) {
        List list3;
        if (from == null) {
            return null;
        }
        Swagger swagger = new Swagger();
        swagger.setVendorExtensions(this.vendorExtensionsMapper.mapExtensions(from.getVendorExtensions()));
        swagger.setSchemes(this.mapSchemes(from.getSchemes()));
        swagger.setPaths(this.mapApiListings(from.getApiListings()));
        swagger.setHost(from.getHost());
        swagger.setDefinitions(this.modelsFromApiListings(from.getApiListings()));
        swagger.setSecurityDefinitions(this.securityMapper.toSecuritySchemeDefinitions(from.getResourceListing()));
        swagger.setInfo(this.mapApiInfo(this.fromResourceListingInfo(from)));
        swagger.setBasePath(from.getBasePath());
        swagger.setTags(this.tagSetToTagList(from.getTags()));
        List list2 = from.getConsumes();
        if (list2 != null) {
            swagger.setConsumes(new ArrayList(list2));
        }
        if ((list3 = from.getProduces()) != null) {
            swagger.setProduces(new ArrayList(list3));
        }
        return swagger;
    }

    protected Info mapApiInfo(ApiInfo from) {
        if (from == null) {
            return null;
        }
        Info info = new Info();
        info.setLicense(this.licenseMapper.apiInfoToLicense(from));
        info.setVendorExtensions(this.vendorExtensionsMapper.mapExtensions(from.getVendorExtensions()));
        info.setTermsOfService(from.getTermsOfServiceUrl());
        info.setContact(this.map(from.getContact()));
        info.setVersion(from.getVersion());
        info.setTitle(from.getTitle());
        info.setDescription(from.getDescription());
        return info;
    }

    protected Contact map(springfox.documentation.service.Contact from) {
        if (from == null) {
            return null;
        }
        Contact contact = new Contact();
        contact.setName(from.getName());
        contact.setUrl(from.getUrl());
        contact.setEmail(from.getEmail());
        return contact;
    }

    protected io.swagger.models.Operation mapOperation(Operation from) {
        Set tags;
        Set set1;
        if (from == null) {
            return null;
        }
        io.swagger.models.Operation operation = new io.swagger.models.Operation();
        operation.setSecurity(this.mapAuthorizations(from.getSecurityReferences()));
        operation.vendorExtensions(this.vendorExtensionsMapper.mapExtensions(from.getVendorExtensions()));
        operation.setDescription(this.messageSource.getMessage(from.getNotes(), null, from.getNotes(), this.locale));
        operation.setOperationId(from.getUniqueId());
        operation.setResponses(this.mapResponseMessages(from.getResponseMessages()));
        operation.setSchemes(this.stringSetToSchemeList(from.getProtocol()));
        operation.setSummary(this.messageSource.getMessage(from.getSummary(), null, from.getSummary(), this.locale));
        Set set = from.getConsumes();
        if (set != null) {
            operation.setConsumes(new ArrayList(set));
        }
        if ((set1 = from.getProduces()) != null) {
            operation.setProduces(new ArrayList(set1));
        }
        if (CollectionUtils.isNotEmpty((Collection)(tags = from.getTags()))) {
            ArrayList<String> i18nTags = new ArrayList<String>(tags.size());
            for (String tagName : from.getTags()) {
                i18nTags.add(StrUtil.isNotBlank((CharSequence)tagName) ? this.messageSource.getMessage(tagName, null, tagName, this.locale) : " ");
            }
            operation.setTags(i18nTags);
        } else {
            operation.setTags(null);
        }
        if (from.getDeprecated() != null) {
            operation.setDeprecated(Boolean.valueOf(Boolean.parseBoolean(from.getDeprecated())));
        }
        operation.setParameters(this.parameterListToParameterList(from.getParameters()));
        return operation;
    }

    protected Tag mapTag(springfox.documentation.service.Tag from) {
        if (from == null) {
            return null;
        }
        Tag tag = new Tag();
        tag.setVendorExtensions(this.vendorExtensionsMapper.mapExtensions(from.getVendorExtensions()));
        tag.setName(this.messageSource.getMessage(from.getName(), null, from.getName(), this.locale));
        tag.setDescription(this.messageSource.getMessage(from.getDescription(), null, from.getDescription(), this.locale));
        return tag;
    }

    private ApiInfo fromResourceListingInfo(Documentation documentation) {
        if (documentation == null) {
            return null;
        }
        ResourceListing resourceListing = documentation.getResourceListing();
        if (resourceListing == null) {
            return null;
        }
        ApiInfo info = resourceListing.getInfo();
        return info == null ? null : info;
    }

    protected List<Tag> tagSetToTagList(Set<springfox.documentation.service.Tag> set) {
        if (set == null) {
            return null;
        }
        ArrayList<Tag> list = new ArrayList<Tag>(set.size());
        for (springfox.documentation.service.Tag tag : set) {
            list.add(this.mapTag(tag));
        }
        return list;
    }

    protected List<Scheme> stringSetToSchemeList(Set<String> set) {
        if (set == null) {
            return null;
        }
        ArrayList<Scheme> list = new ArrayList<Scheme>(set.size());
        for (String string : set) {
            list.add(Enum.valueOf(Scheme.class, string));
        }
        return list;
    }

    protected List<Parameter> parameterListToParameterList(List<springfox.documentation.service.Parameter> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Parameter> list1 = new ArrayList<Parameter>(list.size());
        for (springfox.documentation.service.Parameter param : list) {
            String description = this.messageSource.getMessage(param.getDescription(), null, param.getDescription(), this.locale);
            springfox.documentation.service.Parameter parameter = new springfox.documentation.service.Parameter(param.getName(), description, param.getDefaultValue(), param.isRequired().booleanValue(), param.isAllowMultiple().booleanValue(), param.isAllowEmptyValue(), param.getModelRef(), param.getType(), param.getAllowableValues(), param.getParamType(), param.getParamAccess(), param.isHidden().booleanValue(), param.getPattern(), param.getCollectionFormat(), param.getOrder(), param.getScalarExample(), param.getExamples(), param.getVendorExtentions());
            list1.add(this.parameterMapper.mapParameter(parameter));
        }
        return list1;
    }

    Map<String, Model> modelsFromApiListings(Map<String, List<ApiListing>> apiListings) {
        TreeMap definitions = new TreeMap();
        apiListings.values().stream().flatMap(Collection::stream).forEachOrdered(each -> definitions.putAll(each.getModels()));
        return this.modelMapper.mapModels(definitions);
    }
}

