/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.plugin;

import com.github.xiaoymin.knife4j.annotations.ApiSort;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.github.xiaoymin.knife4j.core.util.CollectionUtils;
import com.github.xiaoymin.knife4j.core.util.StrUtil;
import io.swagger.annotations.Api;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.StringVendorExtension;
import springfox.documentation.service.Tag;
import springfox.documentation.service.Tags;
import springfox.documentation.service.VendorExtension;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ApiListingBuilderPlugin;
import springfox.documentation.spi.service.contexts.ApiListingContext;

@Component
@Order(value=-2147481648)
public class ApiListingOrderReader
implements ApiListingBuilderPlugin {
    public void apply(ApiListingContext apiListingContext) {
        Optional controller = apiListingContext.getResourceGroup().getControllerClass();
        if (controller.isPresent()) {
            Optional<Api> apiAnnotation = Optional.ofNullable((Api)AnnotationUtils.findAnnotation((Class)((Class)controller.get()), Api.class));
            String description = apiAnnotation.map(Api::description).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null);
            Set tagSet = apiAnnotation.map(this.tags()).orElse(new TreeSet());
            if (tagSet.isEmpty()) {
                tagSet.add(apiListingContext.getResourceGroup().getGroupName());
            }
            HashSet<Tag> tagsSet = new HashSet<Tag>();
            Integer order = this.applyOrder(controller);
            String author = this.applyAuthor(controller);
            for (String tagName : tagSet) {
                List vendorExtensions = CollectionUtils.newArrayList((Object[])new VendorExtension[]{new StringVendorExtension("x-order", Objects.toString(order))});
                if (StrUtil.isNotBlank((CharSequence)author)) {
                    vendorExtensions.add(new StringVendorExtension("x-author", author));
                }
                Tag tag = new Tag(tagName, description, vendorExtensions);
                tagsSet.add(tag);
            }
            apiListingContext.apiListingBuilder().tags(tagsSet);
        }
    }

    private String applyAuthor(Optional<? extends Class<?>> controller) {
        Optional<ApiSupport> apiSupportAnnotation = Optional.ofNullable((ApiSupport)AnnotationUtils.findAnnotation(controller.get(), ApiSupport.class));
        if (apiSupportAnnotation.isPresent()) {
            return apiSupportAnnotation.get().author();
        }
        return null;
    }

    private Integer applyOrder(Optional<? extends Class<?>> controller) {
        Optional<ApiSupport> apiSupportAnnotation = Optional.ofNullable((ApiSupport)AnnotationUtils.findAnnotation(controller.get(), ApiSupport.class));
        Optional<ApiSort> apiSortOptional = Optional.ofNullable((ApiSort)AnnotationUtils.findAnnotation(controller.get(), ApiSort.class));
        Integer apiSupportOrder = Integer.MAX_VALUE;
        Integer apiSortOrder = Integer.MAX_VALUE;
        if (apiSupportAnnotation.isPresent()) {
            apiSupportOrder = apiSupportAnnotation.get().order();
        }
        if (apiSortOptional.isPresent()) {
            apiSortOrder = apiSortOptional.get().value();
        }
        Integer min = apiSortOrder.compareTo(apiSupportOrder) < 0 ? apiSortOrder : apiSupportOrder;
        return min;
    }

    public boolean supports(DocumentationType documentationType) {
        return true;
    }

    private Function<Api, Set<String>> tags() {
        return input -> Stream.of(input.tags()).filter(Tags.emptyTags()).collect(Collectors.toCollection(TreeSet::new));
    }
}

