/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.method;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.core.MybatisPlusVersion;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlScriptUtils;
import com.github.yulichang.annotation.DynamicTableName;
import com.github.yulichang.config.ConfigProperties;
import com.github.yulichang.method.SqlMethod;
import com.github.yulichang.toolkit.VersionUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public interface MPJBaseMethod
extends Constants {
    public static final List<String> orderByMethod = Arrays.asList(SqlMethod.SELECT_JOIN_LIST.getMethod(), SqlMethod.SELECT_JOIN_MAPS.getMethod(), SqlMethod.SELECT_JOIN_PAGE.getMethod(), SqlMethod.SELECT_JOIN_MAPS_PAGE.getMethod());

    default public String mpjSqlWhereEntityWrapper(boolean newLine, TableInfo table) {
        if (ConfigProperties.tableInfoAdapter.mpjHasLogic(table)) {
            String sqlScript = this.getAllSqlWhere(table, true, true, "ew.entity.");
            sqlScript = SqlScriptUtils.convertIf((String)sqlScript, (String)String.format("%s != null", "ew.entity"), (boolean)true);
            sqlScript = sqlScript + "\n";
            sqlScript = sqlScript + SqlScriptUtils.convertIf((String)this.getLogicDeleteSql(table, true, true), (String)String.format("%s.logicSql", "ew"), (boolean)true);
            if (ConfigProperties.subTableLogic) {
                sqlScript = sqlScript + "\n" + String.format("${%s.subLogicSql}", "ew");
            }
            sqlScript = sqlScript + SqlScriptUtils.convertIf((String)String.format("AND ${%s}", "ew.sqlSegment"), (String)String.format("%s != null and %s != '' and %s", "ew.sqlSegment", "ew.sqlSegment", "ew.nonEmptyOfNormal"), (boolean)true);
            sqlScript = sqlScript + "\n";
            sqlScript = SqlScriptUtils.convertWhere((String)sqlScript);
            sqlScript = sqlScript + SqlScriptUtils.convertIf((String)String.format(" ${%s}", "ew.sqlSegment"), (String)String.format("%s != null and %s != '' and %s", "ew.sqlSegment", "ew.sqlSegment", "ew.emptyOfNormal"), (boolean)true);
            sqlScript = SqlScriptUtils.convertChoose((String)String.format("%s != null", "ew"), (String)sqlScript, (String)table.getLogicDeleteSql(false, true));
            return newLine ? "\n" + sqlScript : sqlScript;
        }
        String sqlScript = this.getAllSqlWhere(table, false, true, "ew.entity.");
        sqlScript = SqlScriptUtils.convertIf((String)sqlScript, (String)String.format("%s != null", "ew.entity"), (boolean)true);
        sqlScript = sqlScript + "\n";
        if (ConfigProperties.subTableLogic) {
            sqlScript = sqlScript + String.format("${%s.subLogicSql}", "ew") + "\n";
        }
        String s = SqlScriptUtils.convertIf((String)"AND", (String)"ew.nonEmptyOfNormal", (boolean)true);
        sqlScript = sqlScript + SqlScriptUtils.convertIf((String)(s + String.format(" ${%s}", "ew.sqlSegment")), (String)String.format("%s != null and %s != '' and %s", "ew.sqlSegment", "ew.sqlSegment", "ew.nonEmptyOfWhere"), (boolean)true);
        sqlScript = SqlScriptUtils.convertWhere((String)sqlScript) + "\n";
        sqlScript = sqlScript + SqlScriptUtils.convertIf((String)String.format(" ${%s}", "ew.sqlSegment"), (String)String.format("%s != null and %s != '' and %s", "ew.sqlSegment", "ew.sqlSegment", "ew.emptyOfWhere"), (boolean)true);
        sqlScript = SqlScriptUtils.convertIf((String)sqlScript, (String)String.format("%s != null", "ew"), (boolean)true);
        return newLine ? "\n" + sqlScript : sqlScript;
    }

    default public String mpjSqlOrderBy(TableInfo tableInfo) {
        List orderByFields;
        try {
            if (VersionUtils.compare(MybatisPlusVersion.getVersion(), "3.4.3") < 0) {
                return "";
            }
            orderByFields = tableInfo.getOrderByFields();
        }
        catch (Exception e) {
            return "";
        }
        if (CollectionUtils.isEmpty((Collection)orderByFields)) {
            return "";
        }
        orderByFields.sort(Comparator.comparingInt(TableFieldInfo::getOrderBySort));
        StringBuilder sql = new StringBuilder();
        sql.append("\n").append(" ORDER BY ");
        sql.append(orderByFields.stream().map(tfi -> String.format("${ew.alias}.%s %s", tfi.getColumn(), tfi.getOrderByType())).collect(Collectors.joining(",")));
        return SqlScriptUtils.convertIf((String)sql.toString(), (String)String.format("%s == null or %s", "ew", "ew.useAnnotationOrderBy"), (boolean)true);
    }

    default public String getAllSqlWhere(TableInfo tableInfo, boolean ignoreLogicDelFiled, boolean withId, String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        String filedSqlScript = tableInfo.getFieldList().stream().filter(i -> {
            if (ignoreLogicDelFiled) {
                return !ConfigProperties.tableInfoAdapter.mpjHasLogic(tableInfo) || !i.isLogicDelete();
            }
            return true;
        }).map(i -> this.getSqlWhere((TableFieldInfo)i, newPrefix)).filter(Objects::nonNull).collect(Collectors.joining("\n"));
        if (!withId || StringUtils.isBlank((CharSequence)tableInfo.getKeyProperty())) {
            return filedSqlScript;
        }
        String newKeyProperty = newPrefix + tableInfo.getKeyProperty();
        String keySqlScript = ConfigProperties.tableAlias + "." + tableInfo.getKeyColumn() + "=" + SqlScriptUtils.safeParam((String)newKeyProperty);
        return SqlScriptUtils.convertIf((String)keySqlScript, (String)String.format("%s != null", newKeyProperty), (boolean)false) + "\n" + filedSqlScript;
    }

    default public String getSqlWhere(TableFieldInfo tableFieldInfo, String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        String sqlScript = " AND " + String.format(tableFieldInfo.getCondition(), ConfigProperties.tableAlias + "." + tableFieldInfo.getColumn(), newPrefix + tableFieldInfo.getEl());
        return this.convertIf(tableFieldInfo, sqlScript, this.convertIfProperty(newPrefix, tableFieldInfo.getProperty()), tableFieldInfo.getWhereStrategy());
    }

    default public String convertIf(TableFieldInfo tableFieldInfo, String sqlScript, String property, FieldStrategy fieldStrategy) {
        if (fieldStrategy == FieldStrategy.NEVER) {
            return null;
        }
        if (ConfigProperties.tableInfoAdapter.mpjIsPrimitive(tableFieldInfo) || fieldStrategy == FieldStrategy.IGNORED) {
            return sqlScript;
        }
        if (fieldStrategy == FieldStrategy.NOT_EMPTY && tableFieldInfo.isCharSequence()) {
            return SqlScriptUtils.convertIf((String)sqlScript, (String)String.format("%s != null and %s != ''", property, property), (boolean)false);
        }
        return SqlScriptUtils.convertIf((String)sqlScript, (String)String.format("%s != null", property), (boolean)false);
    }

    default public String convertIfProperty(String prefix, String property) {
        return StringUtils.isNotBlank((CharSequence)prefix) ? prefix.substring(0, prefix.length() - 1) + "['" + property + "']" : property;
    }

    default public String getLogicDeleteSql(TableInfo tableInfo, boolean startWithAnd, boolean isWhere) {
        if (ConfigProperties.tableInfoAdapter.mpjHasLogic(tableInfo)) {
            String logicDeleteSql = this.formatLogicDeleteSql(tableInfo, isWhere);
            if (startWithAnd) {
                logicDeleteSql = " AND " + logicDeleteSql;
            }
            return logicDeleteSql;
        }
        return "";
    }

    default public String formatLogicDeleteSql(TableInfo tableInfo, boolean isWhere) {
        String value;
        String string = value = isWhere ? ConfigProperties.tableInfoAdapter.mpjGetLogicField(tableInfo).getLogicNotDeleteValue() : ConfigProperties.tableInfoAdapter.mpjGetLogicField(tableInfo).getLogicDeleteValue();
        if (isWhere) {
            if ("null".equalsIgnoreCase(value)) {
                return "${ew.alias}." + ConfigProperties.tableInfoAdapter.mpjGetLogicField(tableInfo).getColumn() + " IS NULL";
            }
            return "${ew.alias}." + ConfigProperties.tableInfoAdapter.mpjGetLogicField(tableInfo).getColumn() + "=" + String.format(ConfigProperties.tableInfoAdapter.mpjGetLogicField(tableInfo).isCharSequence() ? "'%s'" : "%s", value);
        }
        String targetStr = "${ew.alias}." + tableInfo.getLogicDeleteFieldInfo().getColumn() + "=";
        if ("null".equalsIgnoreCase(value)) {
            return targetStr + "null";
        }
        return targetStr + String.format(tableInfo.getLogicDeleteFieldInfo().isCharSequence() ? "'%s'" : "%s", value);
    }

    default public String mpjSqlSelectColumns() {
        return SqlScriptUtils.convertIf((String)"DISTINCT", (String)"ew.selectDistinct", (boolean)false);
    }

    default public String mpjTableName(TableInfo tableInfo) {
        String encode;
        DynamicTableName dynamicTableName = tableInfo.getEntityType().getAnnotation(DynamicTableName.class);
        if (Objects.isNull(dynamicTableName)) {
            return tableInfo.getTableName();
        }
        String tableName = tableInfo.getTableName();
        try {
            encode = URLEncoder.encode(tableName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            encode = tableName;
        }
        boolean en = tableName.equals(encode);
        return String.format("${ew.getTableName%s(\"%s\")}", en ? "" : "Enc", en ? tableName : encode);
    }
}

